/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.scheduler.cron.CronSyntaxException;
import com.atlassian.scheduler.cron.ErrorCode;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class CronValidationErrorMappingUtil {
    private static final Map<ErrorCode, Mapper> MAPPERS = ImmutableMap.builder().put((Object)ErrorCode.COMMA_WITH_LAST_DOM, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.COMMA_WITH_LAST_DOM")).put((Object)ErrorCode.COMMA_WITH_LAST_DOW, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.COMMA_WITH_LAST_DOW")).put((Object)ErrorCode.COMMA_WITH_NTH_DOW, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.COMMA_WITH_NTH_DOW")).put((Object)ErrorCode.COMMA_WITH_WEEKDAY_DOM, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.COMMA_WITH_WEEKDAY_DOM")).put((Object)ErrorCode.INTERNAL_PARSER_FAILURE, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INTERNAL_PARSER_FAILURE")).put((Object)ErrorCode.ILLEGAL_CHARACTER, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.ILLEGAL_CHARACTER")).put((Object)ErrorCode.ILLEGAL_CHARACTER_AFTER_QM, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.ILLEGAL_CHARACTER_AFTER_QM")).put((Object)ErrorCode.ILLEGAL_CHARACTER_AFTER_HASH, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.ILLEGAL_CHARACTER_AFTER_HASH")).put((Object)ErrorCode.ILLEGAL_CHARACTER_AFTER_INTERVAL, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.ILLEGAL_CHARACTER_AFTER_INTERVAL")).put((Object)ErrorCode.INVALID_STEP, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_STEP")).put((Object)ErrorCode.INVALID_STEP_DAY_OF_MONTH, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_STEP_DAY_OF_MONTH")).put((Object)ErrorCode.INVALID_STEP_DAY_OF_WEEK, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_STEP_DAY_OF_WEEK")).put((Object)ErrorCode.INVALID_STEP_HOUR, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_STEP_HOUR")).put((Object)ErrorCode.INVALID_STEP_MONTH, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_STEP_MONTH")).put((Object)ErrorCode.INVALID_STEP_SECOND_OR_MINUTE, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_STEP_SECOND_OR_MINUTE")).put((Object)ErrorCode.INVALID_NAME, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_NAME")).put((Object)ErrorCode.INVALID_NAME_FIELD, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_NAME_FIELD")).put((Object)ErrorCode.INVALID_NAME_RANGE, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NAME_RANGE")).put((Object)ErrorCode.INVALID_NAME_MONTH, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_NAME_MONTH")).put((Object)ErrorCode.INVALID_NAME_DAY_OF_WEEK, (Object)CronValidationErrorMappingUtil.withArg("cron.expression.invalid.INVALID_NAME_DAY_OF_WEEK")).put((Object)ErrorCode.INVALID_NUMBER_SEC_OR_MIN, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NUMBER_SEC_OR_MIN")).put((Object)ErrorCode.INVALID_NUMBER_HOUR, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NUMBER_HOUR")).put((Object)ErrorCode.INVALID_NUMBER_DAY_OF_MONTH, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NUMBER_DAY_OF_MONTH")).put((Object)ErrorCode.INVALID_NUMBER_DAY_OF_MONTH_OFFSET, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NUMBER_DAY_OF_MONTH_OFFSET")).put((Object)ErrorCode.INVALID_NUMBER_MONTH, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NUMBER_MONTH")).put((Object)ErrorCode.INVALID_NUMBER_DAY_OF_WEEK, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NUMBER_DAY_OF_WEEK")).put((Object)ErrorCode.INVALID_NUMBER_YEAR, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NUMBER_YEAR")).put((Object)ErrorCode.INVALID_NUMBER_YEAR_RANGE, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.INVALID_NUMBER_YEAR_RANGE")).put((Object)ErrorCode.QM_CANNOT_USE_HERE, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.QM_CANNOT_USE_HERE")).put((Object)ErrorCode.QM_CANNOT_USE_FOR_BOTH_DAYS, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.QM_CANNOT_USE_FOR_BOTH_DAYS")).put((Object)ErrorCode.QM_MUST_USE_FOR_ONE_OF_DAYS, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.QM_MUST_USE_FOR_ONE_OF_DAYS")).put((Object)ErrorCode.UNEXPECTED_TOKEN_FLAG_L, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.UNEXPECTED_TOKEN_FLAG_L")).put((Object)ErrorCode.UNEXPECTED_TOKEN_FLAG_W, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.UNEXPECTED_TOKEN_FLAG_W")).put((Object)ErrorCode.UNEXPECTED_TOKEN_HASH, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.UNEXPECTED_TOKEN_HASH")).put((Object)ErrorCode.UNEXPECTED_TOKEN_HYPHEN, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.UNEXPECTED_TOKEN_HYPHEN")).put((Object)ErrorCode.UNEXPECTED_END_OF_EXPRESSION, (Object)CronValidationErrorMappingUtil.simple("cron.expression.invalid.UNEXPECTED_END_OF_EXPRESSION")).build();

    private CronValidationErrorMappingUtil() {
    }

    public static String internalError(@Nonnull String message, @Nonnull I18nHelper i18nHelper) {
        return i18nHelper.getText("cron.expression.invalid.INTERNAL_PARSER_FAILURE", message);
    }

    public static String mapError(@Nonnull CronSyntaxException cse, @Nonnull I18nHelper i18nHelper) {
        Mapper mapper = MAPPERS.get(cse.getErrorCode());
        if (mapper != null) {
            return mapper.getText(i18nHelper, cse);
        }
        return cse.getMessage();
    }

    private static Mapper simple(String messageKey) {
        return new Simple(messageKey);
    }

    private static Mapper withArg(String messageKey) {
        return new WithArg(messageKey);
    }

    static class WithArg
    extends Simple {
        WithArg(String messageKey) {
            super(messageKey);
        }

        @Override
        public String getText(I18nHelper i18n, CronSyntaxException cse) {
            return i18n.getText(this.messageKey, cse.getValue());
        }
    }

    static class Simple
    implements Mapper {
        final String messageKey;

        Simple(String messageKey) {
            this.messageKey = messageKey;
        }

        @Override
        public String getText(I18nHelper i18n, CronSyntaxException cse) {
            return i18n.getText(this.messageKey);
        }
    }

    static interface Mapper {
        public String getText(I18nHelper var1, CronSyntaxException var2);
    }
}

