/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.search;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.Comparator;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class GenericValueComparator
implements Comparator<GenericValue> {
    private final String field;
    private final Comparator<Object> delegate;

    public GenericValueComparator(String field) {
        this(field, ComparatorUtils.nullLowComparator((Comparator)ComparatorUtils.naturalComparator()));
    }

    public GenericValueComparator(String field, Comparator<Object> delegate) {
        if (StringUtils.isBlank((String)field)) {
            throw new IllegalArgumentException("field is blank");
        }
        Assertions.notNull((String)"delegate", delegate);
        this.field = field;
        this.delegate = delegate;
    }

    @Override
    public int compare(GenericValue o1, GenericValue o2) {
        Assertions.notNull((String)"o1", (Object)o1);
        Assertions.notNull((String)"o2", (Object)o2);
        return this.delegate.compare(o1.get(this.field), o2.get(this.field));
    }
}

