/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.dataimport.DataImportParams;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.license.MultiLicenseStore;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.IOUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseInitialImporter {
    private static final Logger log = LoggerFactory.getLogger(DatabaseInitialImporter.class);
    private static final String STARTUP_XML = "startupdatabase.xml";
    private static final String PERMISSION_SCHEME_ENTITY_NAME = "PermissionScheme";

    public boolean dataAlreadyLoaded() {
        DelegatorInterface delegator = ComponentAccessor.getOfBizDelegator().getDelegatorInterface();
        try {
            return delegator.countAll(PERMISSION_SCHEME_ENTITY_NAME) > 0;
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }

    public void importInitialData(ApplicationUser loggedInUser) {
        this.importInitialData(loggedInUser, (Option<String>)Option.none(), (Option<String>)Option.none());
    }

    public void importInitialData(ApplicationUser loggedInUser, Option<String> serverId, Option<String> license) {
        DataImportService.ImportValidationResult result;
        Path path = this.copyStartupXmlIntoHome();
        DataImportService dataImportService = (DataImportService)ComponentAccessor.getComponent(DataImportService.class);
        DataImportService.ImportResult importResult = dataImportService.doImport(loggedInUser, result = dataImportService.validateImport(loggedInUser, this.buildDataImportParameters(path, license)), TaskProgressSink.NULL_SINK);
        if (!importResult.isValid()) {
            log.error(importResult.getSpecificErrorMessage());
            importResult.getErrorCollection().getErrorMessages().forEach(arg_0 -> ((Logger)log).error(arg_0));
            importResult.getErrorCollection().getErrors().values().forEach(arg_0 -> ((Logger)log).error(arg_0));
        }
        if (serverId.isDefined()) {
            MultiLicenseStore component = (MultiLicenseStore)ComponentAccessor.getComponent(MultiLicenseStore.class);
            component.storeServerId((String)serverId.get());
        }
    }

    private DataImportParams buildDataImportParameters(Path xmlPath, Option<String> license) {
        DataImportParams.Builder builder = new DataImportParams.Builder(xmlPath.getFileName().toString()).setUseDefaultPaths(true).setAllowDowngrade(false).setupImport().setStartupDataOnly().setOutgoingEmailTo(true).setQuickImport(true).setUnsafeJiraBackup(xmlPath.toFile());
        if (license.isDefined()) {
            builder.setLicenseString((String)license.get());
        }
        return builder.build();
    }

    private Path copyStartupXmlIntoHome() {
        JiraHome jiraHome = (JiraHome)ComponentAccessor.getComponent(JiraHome.class);
        Path importPath = jiraHome.getImportDirectory().toPath().resolve(STARTUP_XML);
        InputStream startupStream = this.getClass().getResourceAsStream("/startupdatabase.xml");
        try {
            Files.copy(startupStream, importPath, StandardCopyOption.REPLACE_EXISTING);
            Path path = importPath;
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)startupStream);
        }
    }
}

