/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.startup.InstantUpgradeManager;
import com.atlassian.jira.util.StopWatch;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInstantUpgradeManager
implements InstantUpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultInstantUpgradeManager.class);
    private static final String LOG_KEY = "jira.launcher.start.instanceenabled.millis";
    private final AtomicReference<Runnable> taskReference = new AtomicReference();
    private final AtomicBoolean activated = new AtomicBoolean(false);
    private final JiraProperties jiraProperties;
    private String description;

    public DefaultInstantUpgradeManager(JiraProperties jiraProperties) {
        this.jiraProperties = jiraProperties;
    }

    @Override
    public void doNowOrWhenInstanceBecomesActive(Runnable task, String description) {
        if (!this.isInstantUpgradeEnabled()) {
            this.runTask(task);
        } else if (this.taskReference.compareAndSet(null, task)) {
            this.description = description;
            log.info("Instant Upgrade in progress. Task [{}] registered. Awaiting instance to be activated", (Object)description);
        } else {
            throw new IllegalStateException("Instance Upgrade task has already been registered");
        }
    }

    private void runTask(Runnable task) {
        log.info("Now running [{}]", (Object)this.description);
        StopWatch stopWatch = new StopWatch();
        task.run();
        long elapsedTime = stopWatch.getTotalTime();
        MDC.put((String)LOG_KEY, (Object)elapsedTime);
        log.info("{} took {}s", (Object)this.description, (Object)(elapsedTime / 1000L));
        MDC.remove((String)LOG_KEY);
    }

    @Override
    public InstantUpgradeManager.State getState() {
        if (!this.isInstantUpgradeEnabled()) {
            return InstantUpgradeManager.State.DISABLED;
        }
        if (this.hasErrorOrFatalJohnsonEvents()) {
            return InstantUpgradeManager.State.ERROR;
        }
        if (this.taskReference.get() == null) {
            return InstantUpgradeManager.State.STARTING;
        }
        if (!this.activated.get()) {
            return InstantUpgradeManager.State.WAITING;
        }
        return InstantUpgradeManager.State.ACTIVATED;
    }

    @Override
    public ServiceResult activateInstance() {
        if (!this.isInstantUpgradeEnabled()) {
            return ServiceOutcomeImpl.error("Instance upgrade is NOT enabled, ignoring instance activation request.");
        }
        if (this.taskReference.get() == null) {
            return ServiceOutcomeImpl.error("Instance upgrade task was not set, ignoring instance activation request.");
        }
        if (!this.activated.compareAndSet(false, true)) {
            return ServiceOutcomeImpl.error("Instance is already activated, ignoring instance activation request.");
        }
        try {
            this.runTask(this.taskReference.get());
            return ServiceOutcomeImpl.ok(null);
        }
        catch (Exception e) {
            JohnsonProvider johnsonProvider = (JohnsonProvider)ComponentAccessor.getComponentOfType(JohnsonProvider.class);
            log.error("Unable to start JIRA.", (Throwable)e);
            String errorMessage = "Unexpected exception during JIRA startup. This JIRA instance will not be able to recover. Please check the logs for details.";
            johnsonProvider.getContainer().addEvent(new Event(EventType.get((String)"startup-unexpected"), errorMessage, EventLevel.get((String)"fatal")));
            return ServiceOutcomeImpl.error(errorMessage);
        }
    }

    private boolean isInstantUpgradeEnabled() {
        return this.jiraProperties.getBoolean("instant.upgrade");
    }

    private boolean hasErrorOrFatalJohnsonEvents() {
        return !((JohnsonProvider)ComponentAccessor.getComponentOfType(JohnsonProvider.class)).getContainer().getEvents().isEmpty();
    }
}

