/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.task.TaskProgressSink;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRecoveryLauncher
implements JiraLauncher {
    private static final String DR_PROPERTY_KEY = "disaster.recovery";
    private static final Logger LOG = LoggerFactory.getLogger(IndexRecoveryLauncher.class);

    private boolean isStandaloneMode() {
        return !((ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class)).getOption(DR_PROPERTY_KEY) && !((ClusterManager)ComponentAccessor.getComponent(ClusterManager.class)).isClustered();
    }

    @Override
    public void start() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        if ("true".equals(applicationProperties.getString("jira.setup")) && this.isStandaloneMode()) {
            IndexRecoveryManager recoveryManager = (IndexRecoveryManager)ComponentAccessor.getComponent(IndexRecoveryManager.class);
            try {
                DateUtils.DateRange dateRange = recoveryManager.getDurationToRecover();
                if (dateRange == null) {
                    return;
                }
                long difference = Math.abs(dateRange.endDate.getTime() - dateRange.startDate.getTime());
                if (difference > TimeUnit.DAYS.toMillis(1L)) {
                    LOG.info("Issue index is out of date with the database by more than 24 hours. Automatic recovery is not attempted");
                    return;
                }
                if (difference > 1000L) {
                    LOG.info("Recover Issue Index - start");
                }
                recoveryManager.reindexIssuesIn(dateRange, TaskProgressSink.NULL_SINK);
                if (difference > 1000L) {
                    LOG.info("Recover Issue Index - end");
                }
            }
            catch (IndexException e) {
                LOG.error("Automatic index recovery failed", (Throwable)e);
            }
            catch (SearchException e) {
                LOG.error("Automatic index recovery failed", (Throwable)e);
            }
            catch (RuntimeException e) {
                LOG.error("Automatic index recovery failed", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
    }
}

