/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.task.TaskProgressSink;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public class ProgressMonitoringFileInputStream
extends FilterInputStream {
    private long nread = 0L;
    private final String subTask;
    private final String message;
    private final TaskProgressSink taskProgressSink;

    public ProgressMonitoringFileInputStream(InputStream in, TaskProgressSink taskProgressSink, String subTask, String message) {
        super(in);
        this.subTask = subTask;
        this.message = message;
        this.taskProgressSink = taskProgressSink;
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        return this.recordProgress(read);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        return this.recordProgress(read);
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        return this.recordProgress(read);
    }

    private int recordProgress(int read) {
        this.nread += (long)read;
        this.taskProgressSink.makeProgress(this.nread, this.subTask, MessageFormat.format(this.message, FileSize.format((long)this.nread)));
        return read;
    }
}

