/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build606
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build606.class);
    private final PropertiesManager propertiesManager;

    public UpgradeTask_Build606(PropertiesManager propertiesManager) {
        this.propertiesManager = propertiesManager;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.removeOption("jira.path.backup");
        log.debug("Removed deprecated application properties");
    }

    private void removeOption(String key) {
        PropertySet ps = this.propertiesManager.getPropertySet();
        if (ps.exists(key)) {
            ps.remove(key);
        }
    }

    @Override
    public String getBuildNumber() {
        return "606";
    }

    @Override
    public String getShortDescription() {
        return "Cleans up left over application properties";
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "605";
    }
}

