/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.portal.CachingPortletConfigurationStore;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build70007
extends AbstractImmediateUpgradeTask {
    private static final String INTRO_DASHBOARD_ITEM_KEY = "com.atlassian.jira.gadgets:introduction-dashboard-item";
    private static final String INTRO_GADGET_XML = "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml";
    private final OfBizDelegator delegator;
    private final CachingPortletConfigurationStore cachingPortletConfigurationStore;

    public UpgradeTask_Build70007(OfBizDelegator delegator, CachingPortletConfigurationStore cachingPortletConfigurationStore) {
        this.delegator = delegator;
        this.cachingPortletConfigurationStore = cachingPortletConfigurationStore;
    }

    @Override
    public String getBuildNumber() {
        return "70007";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        EntityExpr condition = new EntityExpr("gadgetXml", EntityOperator.LIKE, (Object)INTRO_GADGET_XML);
        OfBizListIterator gadgetsIterator = this.delegator.findListIteratorByCondition("PortletConfiguration", (EntityCondition)condition);
        try {
            for (GenericValue row : gadgetsIterator) {
                row.set("dashboardModuleCompleteKey", (Object)INTRO_DASHBOARD_ITEM_KEY);
                this.delegator.store(row);
            }
        }
        finally {
            this.cachingPortletConfigurationStore.flush();
            gadgetsIterator.close();
        }
    }

    @Override
    public boolean isDowngradeTaskRequired() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return "Converts jira-introduction-gadget to jira-introduction-dashboard-item";
    }
}

