/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.google.common.collect.Multimap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class GlobalPermissionDao {
    GlobalPermissionDao() {
    }

    abstract Set<Group> groupsWithUsePermission();

    abstract Set<Group> groupsWithAdminPermission();

    abstract Multimap<Group, AdminPermission> groupsWithAdminPermissionAndPermissionType();

    abstract Set<Group> groupsWithSdAgentPermission();

    public static enum AdminPermission {
        ADMIN("ADMINISTER"),
        SYSADMIN("SYSTEM_ADMIN");

        private final String ofBizKey;

        private AdminPermission(String ofBizKey) {
            this.ofBizKey = ofBizKey;
        }

        @Nonnull
        public String ofBizKey() {
            return this.ofBizKey;
        }

        public static Option<AdminPermission> from(@Nullable String permissionKey) {
            if (permissionKey == null) {
                return Option.none();
            }
            if (ADMIN.ofBizKey().equalsIgnoreCase(permissionKey)) {
                return Option.some((Object)((Object)ADMIN));
            }
            if (SYSADMIN.ofBizKey().equalsIgnoreCase(permissionKey)) {
                return Option.some((Object)((Object)SYSADMIN));
            }
            return Option.none();
        }
    }
}

