/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.jira.license.JiraProductLicense;
import com.atlassian.jira.license.LicenseDetailsFactoryImpl;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

final class License {
    private static final LicenseDetailsFactoryImpl.JiraProductLicenseManager FACTORY = LicenseDetailsFactoryImpl.JiraProductLicenseManager.INSTANCE;
    private final JiraProductLicense productLicense;
    private final String licenseString;

    License(String licenseString) throws LicenseException {
        this.licenseString = (String)Assertions.notNull((String)"licenseString", (Object)licenseString);
        try {
            this.productLicense = FACTORY.getProductLicense(licenseString);
        }
        catch (LicenseException e) {
            String msg = String.format("Unable to parse license: %s", License.abbreviate(licenseString));
            throw new MigrationFailedException(msg, e);
        }
    }

    JiraProductLicense productLicense() {
        return this.productLicense;
    }

    String licenseString() {
        return this.licenseString;
    }

    Set<ApplicationKey> applicationKeys() {
        return this.productLicense.getApplications().getKeys();
    }

    String abbreviatedLicenseString() {
        return License.abbreviate(this.licenseString);
    }

    String getSEN() {
        return this.productLicense.getSupportEntitlementNumber();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        return this.licenseString.equals(license.licenseString);
    }

    public int hashCode() {
        return this.licenseString.hashCode();
    }

    public String toString() {
        return String.format("License for %s: %s.", this.productLicense.getApplications().getKeys(), this.abbreviatedLicenseString());
    }

    private static String abbreviate(String licenseString) {
        return StringUtils.abbreviate((String)licenseString, (int)40);
    }
}

