/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.util;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.upgrade.util.LegacyPortletUpgradeTask;
import com.atlassian.jira.upgrade.util.LegacyPortletUpgradeTaskFactory;
import com.atlassian.jira.upgrade.util.SimpleLegacyPortletUpgradeTask;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLegacyPortletUpgradeTaskFactory
implements LegacyPortletUpgradeTaskFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultLegacyPortletUpgradeTaskFactory.class);
    private final Set<LegacyPortletUpgradeTask> upgradeTasks = this.getUpgradeTasks();
    private static final int DEFAULT_MAX_ROWS = 50;
    private final int maxRows;

    public DefaultLegacyPortletUpgradeTaskFactory(ApplicationProperties applicationProperties) {
        this.maxRows = this.getMaxRows(applicationProperties);
    }

    private int getMaxRows(ApplicationProperties applicationProperties) {
        try {
            if (applicationProperties != null) {
                String maxRowsStr = applicationProperties.getDefaultBackedString("jira.table.gadget.max.rows");
                if (StringUtils.isNotBlank((String)maxRowsStr)) {
                    return Integer.valueOf(maxRowsStr);
                }
                log.warn("'jira.table.gadget.max.rows' doesn't exist in jira-application.properties");
            }
        }
        catch (NumberFormatException e) {
            log.warn("'jira.table.gadget.max.rows' contains something thats not a number!", (Throwable)e);
        }
        return 50;
    }

    @Override
    public Map<String, LegacyPortletUpgradeTask> createPortletToUpgradeTaskMapping() {
        MapBuilder builder = MapBuilder.newBuilder();
        for (LegacyPortletUpgradeTask upgradeTask : this.upgradeTasks) {
            builder.add((Object)upgradeTask.getPortletKey(), (Object)upgradeTask);
        }
        return builder.toSortedMap();
    }

    private Set<LegacyPortletUpgradeTask> getUpgradeTasks() {
        CollectionBuilder legacyPortletUpgradeTaskCollectionBuilder = CollectionBuilder.newBuilder().add((Object)new ProjectStatsLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:projectstats", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:stats-gadget/gadgets/stats-gadget.xml")).add((Object)new ProjectStatsLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:filterstats", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:stats-gadget/gadgets/stats-gadget.xml")).add((Object)new ProjectStatsLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:pie", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:pie-chart-gadget/gadgets/piechart-gadget.xml")).add((Object)new RoadMapPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:roadmap", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:road-map-gadget/gadgets/roadmap-gadget.xml")).add((Object)new SimpleLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:introduction", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml")).add((Object)new SimpleLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:savedfilters", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:favourite-filters-gadget/gadgets/favourite-filters-gadget.xml")).add((Object)new CreatedVsResolvedLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:createdvsresolved", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:created-vs-resolved-issues-chart-gadget/gadgets/createdvsresolved-gadget.xml")).add((Object)new SimpleLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:admin", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:admin-gadget/gadgets/admin-gadget.xml")).add((Object)new ProjectLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:projects", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:project-gadget/gadgets/project-gadget.xml")).add((Object)new ProjectLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:project", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:project-gadget/gadgets/project-gadget.xml")).add((Object)new ProjectTableLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:projecttable", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:project-gadget/gadgets/project-gadget.xml")).add((Object)new FilterResultsLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:searchrequest", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:filter-results-gadget/gadgets/filter-results-gadget.xml")).add((Object)new SimpleLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:averageage", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:average-age-chart-gadget/gadgets/average-age-gadget.xml")).add((Object)new SimpleLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:recentlycreated", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:recently-created-chart-gadget/gadgets/recently-created-gadget.xml")).add((Object)new SimpleLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:userissues", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:quicklinks-gadget/gadgets/quicklinks-gadget.xml")).add((Object)new AssignedToMeLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:assignedtome", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:assigned-to-me-gadget/gadgets/assigned-to-me-gadget.xml")).add((Object)new InProgressLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:inprogress", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:in-progress-gadget/gadgets/in-progress-gadget.xml")).add((Object)new WatchedPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:mywatches", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:watched-gadget/gadgets/watched-gadget.xml")).add((Object)new VotedPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:myvotes", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:voted-gadget/gadgets/voted-gadget.xml")).add((Object)new TwoDimensionalStatsLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:filterstatsdouble", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:two-dimensional-stats-gadget/gadgets/two-dimensional-stats-gadget.xml")).add((Object)new TimeSinceLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:timesince", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml")).add((Object)new SimpleLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:resolutiontime", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:resolution-time-gadget/gadgets/resolution-time-gadget.xml")).add((Object)new SimpleLegacyPortletUpgradeTask("com.atlassian.jira.plugin.system.portlets:text", "rest/gadgets/1.0/g/com.atlassian.jira.gadgets:text-gadget/gadgets/text-gadget.xml")).add((Object)new CrucibleChartingPortletUpgradeTask("com.atlassian.jira.ext.fisheye:cruciblecharting", "rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:crucible-charting-gadget/gadgets/crucible-charting-gadget.xml")).add((Object)new FishEyeChartingPortletUpgradeTask("com.atlassian.jira.ext.fisheye:fisheyecharting", "rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-charting-gadget/gadgets/fisheye-charting-gadget.xml")).add((Object)new FishEyeRecentCommitsPortletUpgradeTask("com.atlassian.jira.ext.fisheye:fisheyerecentcommits", "rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml"));
        return legacyPortletUpgradeTaskCollectionBuilder.asSet();
    }

    private static void rebindEntryIfExists(Map<String, String> map, String oldKey, String newKey) {
        String oldVal = map.remove(oldKey);
        if (oldVal != null) {
            map.put(newKey, oldVal);
        }
    }

    private void scrubNumberToShow(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            String numToShowStr = map.get(key);
            try {
                if (StringUtils.isNumeric((String)numToShowStr) && StringUtils.isNotBlank((String)numToShowStr)) {
                    int num = Integer.parseInt(numToShowStr);
                    if (num > this.maxRows) {
                        map.put(key, "" + this.maxRows);
                    } else if (num <= 0) {
                        map.put(key, "5");
                    }
                } else {
                    map.put(key, "5");
                }
            }
            catch (NumberFormatException e) {
                map.put(key, "5");
            }
        }
    }

    private class FishEyeRecentCommitsPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public FishEyeRecentCommitsPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "repository", "rep");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "numtodisplay", "numberToShow");
            return map;
        }
    }

    private class FishEyeChartingPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public FishEyeChartingPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "author", "authors");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "extension", "extensions");
            return map;
        }
    }

    private class CrucibleChartingPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public CrucibleChartingPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Integer COMMENT_VOLUME = new Integer(10);
            Integer DEFECT_CLASSIFICATION = new Integer(20);
            Integer DEFECT_RANK = new Integer(30);
            Integer OPEN_REVIEWS = new Integer(40);
            Integer OPEN_REVIEW_AGE = new Integer(50);
            Map NAMES = Collections.unmodifiableMap(EasyMap.build((Object)OPEN_REVIEWS, (Object)"openReviews", (Object)OPEN_REVIEW_AGE, (Object)"openReviewAge", (Object)COMMENT_VOLUME, (Object)"commentVolume", (Object)DEFECT_CLASSIFICATION, (Object)"defectClassification", (Object)DEFECT_RANK, (Object)"defectRank"));
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "type", "charttype");
            String charttype = map.get("charttype");
            if (charttype != null) {
                String newChartType = null;
                try {
                    newChartType = (String)NAMES.get(Integer.parseInt(charttype));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (newChartType == null) {
                    map.put("isConfigured", "false");
                } else {
                    map.put("charttype", newChartType);
                }
            }
            return map;
        }
    }

    private class SearchRequestUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public SearchRequestUpgradeTask(String s, String s1) {
            super(s, s1);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "numofentries", "num");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "filterid", "filterId");
            return map;
        }
    }

    private class CreatedVsResolvedLegacyPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        private CreatedVsResolvedLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "cumulative", "isCumulative");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "versionLabels", "versionLabel");
            return map;
        }
    }

    private class RoadMapPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        private RoadMapPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "maxresults", "num");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "projectsEnt", "projectsOrCategories");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "projects", "projectsOrCategories");
            return map;
        }
    }

    private class ProjectLegacyPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        private ProjectLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            String projectCat;
            Map<String, String> map = super.convertUserPrefs(propertySet);
            String project = map.remove("projectid");
            if (project != null) {
                map.put("projectsOrCategories", project);
            }
            if ((projectCat = map.remove("projectcategoryid")) != null) {
                if (projectCat.equals("")) {
                    map.put("projectsOrCategories", "allprojects");
                } else {
                    map.put("projectsOrCategories", "cat" + projectCat);
                }
            }
            return map;
        }
    }

    private class ProjectTableLegacyPortletUpgradeTask
    extends ProjectLegacyPortletUpgradeTask {
        private ProjectTableLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "numofcolumns", "cols");
            this.scrubColsToShow(map, "cols");
            map.put("viewType", "collapsed");
            return map;
        }

        private void scrubColsToShow(Map<String, String> map, String key) {
            if (map.containsKey(key)) {
                String numToShowStr = map.get(key);
                if (StringUtils.isNotBlank((String)numToShowStr)) {
                    if (numToShowStr.equals("1")) {
                        map.put(key, "single-col");
                    } else if (numToShowStr.equals("2")) {
                        map.put(key, "two-col");
                    } else if (numToShowStr.equals("3")) {
                        map.put(key, "three-col");
                    } else {
                        map.put(key, "three-col");
                    }
                } else {
                    map.put(key, "three-col");
                }
            }
        }
    }

    private class ProjectStatsLegacyPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        private ProjectStatsLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            String filter;
            Map<String, String> map = super.convertUserPrefs(propertySet);
            String project = map.remove("projectid");
            if (project != null) {
                if (project.startsWith("project-")) {
                    map.put("projectOrFilterId", project);
                } else {
                    map.put("projectOrFilterId", "project-" + project);
                }
            }
            if ((filter = map.remove("filterid")) != null) {
                if (filter.startsWith("filter-")) {
                    map.put("projectOrFilterId", filter);
                } else {
                    map.put("projectOrFilterId", "filter-" + filter);
                }
            }
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "showclosed", "includeResolvedIssues");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "statistictype", "statType");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "sortOrder", "sortBy");
            return map;
        }
    }

    private class InProgressLegacyPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        private InProgressLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "numofentries", "num");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "showHeader", "displayHeader");
            DefaultLegacyPortletUpgradeTaskFactory.this.scrubNumberToShow(map, "num");
            return map;
        }
    }

    private class AssignedToMeLegacyPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        private AssignedToMeLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "numofentries", "num");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "showHeader", "displayHeader");
            DefaultLegacyPortletUpgradeTaskFactory.this.scrubNumberToShow(map, "num");
            return map;
        }
    }

    private class WatchedPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public WatchedPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "numofentries", "num");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "showTotals", "showTotalWatches");
            DefaultLegacyPortletUpgradeTaskFactory.this.scrubNumberToShow(map, "num");
            return map;
        }
    }

    private class VotedPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public VotedPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "numofentries", "num");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "showTotals", "showTotalVotes");
            DefaultLegacyPortletUpgradeTaskFactory.this.scrubNumberToShow(map, "num");
            return map;
        }
    }

    private class TwoDimensionalStatsLegacyPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public TwoDimensionalStatsLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "xAxis", "xstattype");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "yAxis", "ystattype");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "yAxisDirection", "sortDirection");
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "yAxisOrder", "sortBy");
            String filter = map.remove("filterid");
            if (filter != null) {
                if (filter.startsWith("filter-")) {
                    map.put("filterId", filter);
                } else {
                    map.put("filterId", "filter-" + filter);
                }
            }
            String key = "numberToShow";
            if (map.containsKey("numberToShow")) {
                String numToShowStr = map.get("numberToShow");
                try {
                    if (StringUtils.isNumeric((String)numToShowStr) && StringUtils.isNotBlank((String)numToShowStr)) {
                        int num = Integer.parseInt(numToShowStr);
                        if (num <= 0) {
                            map.put("numberToShow", "5");
                        }
                    } else {
                        map.put("numberToShow", "5");
                    }
                }
                catch (NumberFormatException e) {
                    map.put("numberToShow", "5");
                }
            }
            return map;
        }
    }

    private class TimeSinceLegacyPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public TimeSinceLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "cumulative", "isCumulative");
            return map;
        }
    }

    private class FilterResultsLegacyPortletUpgradeTask
    extends SimpleLegacyPortletUpgradeTask {
        public FilterResultsLegacyPortletUpgradeTask(String portletKey, String gadgetUri) {
            super(portletKey, gadgetUri);
        }

        @Override
        public Map<String, String> convertUserPrefs(PropertySet propertySet) {
            Map<String, String> map = super.convertUserPrefs(propertySet);
            DefaultLegacyPortletUpgradeTaskFactory.rebindEntryIfExists(map, "numofentries", "num");
            DefaultLegacyPortletUpgradeTaskFactory.this.scrubNumberToShow(map, "num");
            String filter = map.remove("filterid");
            if (filter != null) {
                if (filter.startsWith("filter-")) {
                    map.put("filterId", filter);
                } else {
                    map.put("filterId", "filter-" + filter);
                }
            }
            return map;
        }
    }
}

