/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.jcip.annotations.ThreadSafe;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OfBizUserHistoryStore
implements UserHistoryStore {
    private static final Logger LOG = LoggerFactory.getLogger(OfBizUserHistoryStore.class);
    private static final int DEFAULT_MAX_ITEMS = 50;
    private static final String TABLE = "UserHistoryItem";
    private static final String ID = "id";
    private static final String USER = "username";
    private static final String TYPE = "type";
    private static final String ENTITY_ID = "entityId";
    private static final String LAST_VIEWED = "lastViewed";
    private static final String DATA = "data";
    private static final List<String> SORT_BY_LAST_VIEWED_DESC = ImmutableList.of((Object)"lastViewed DESC");
    private final OfBizDelegator delegator;
    private final ApplicationProperties applicationProperties;

    public OfBizUserHistoryStore(OfBizDelegator delegator, ApplicationProperties applicationProperties) {
        this.delegator = delegator;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void addHistoryItem(ApplicationUser user, @Nonnull UserHistoryItem item) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"historyItem", (Object)item);
        int numberRemoved = this.delegator.removeByAnd(TABLE, (Map)FieldMap.build((String)TYPE, (Object)item.getType().getName(), (String)USER, (Object)user.getKey(), (String)ENTITY_ID, (Object)item.getEntityId()));
        this.addHistoryItemNoChecks(user, item);
        if (numberRemoved == 0) {
            String maxItemsStr = this.applicationProperties.getDefaultBackedString("jira.max.history.items");
            int maxItems = 50;
            try {
                maxItems = Integer.parseInt(maxItemsStr);
            }
            catch (NumberFormatException e) {
                LOG.warn("Incorrect format of property 'jira.max.history.items'.  Should be a number.");
            }
            List historyItemGVs = this.delegator.findByAnd(TABLE, (Map)FieldMap.build((String)TYPE, (Object)item.getType().getName(), (String)USER, (Object)user.getKey()), SORT_BY_LAST_VIEWED_DESC);
            for (int i = maxItems; i < historyItemGVs.size(); ++i) {
                this.delegator.removeByAnd(TABLE, (Map)FieldMap.build((String)ID, (Object)((GenericValue)historyItemGVs.get(i)).getLong(ID)));
            }
        }
    }

    boolean removeHistoryItem(@Nonnull ApplicationUser user, @Nonnull UserHistoryItem item) {
        FieldMap fields = FieldMap.build((String)TYPE, (Object)item.getType().getName(), (String)USER, (Object)user.getKey(), (String)ENTITY_ID, (Object)item.getEntityId());
        return this.delegator.removeByAnd(TABLE, (Map)fields) > 0;
    }

    public void addHistoryItemNoChecks(@Nonnull ApplicationUser user, @Nonnull UserHistoryItem item) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"historyItem", (Object)item);
        this.delegator.createValue(TABLE, MapBuilder.newBuilder().add((Object)TYPE, (Object)item.getType().getName()).add((Object)USER, (Object)user.getKey()).add((Object)ENTITY_ID, (Object)item.getEntityId()).add((Object)LAST_VIEWED, (Object)item.getLastViewed()).add((Object)DATA, (Object)item.getData()).toMap());
    }

    public void updateHistoryItemNoChecks(@Nonnull ApplicationUser user, @Nonnull UserHistoryItem item) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"historyItem", (Object)item);
        List list = this.delegator.findByAnd(TABLE, (Map)FieldMap.build((String)TYPE, (Object)item.getType().getName(), (String)USER, (Object)user.getKey(), (String)ENTITY_ID, (Object)item.getEntityId()));
        if (list.isEmpty()) {
            this.createHistoryItemNoChecks(user, item);
        } else if (list.size() == 1) {
            OfBizUserHistoryStore.updateHistoryItemLastViewed((GenericValue)list.get(0), item.getLastViewed());
        } else {
            LOG.warn("Somehow there is more than one record for the following user/type/entity - " + item.toString());
        }
    }

    private static void updateHistoryItemLastViewed(@Nonnull GenericValue genericValue, long lastViewed) {
        genericValue.set(LAST_VIEWED, (Object)lastViewed);
        try {
            genericValue.store();
        }
        catch (GenericEntityException e) {
            LOG.error("Exception thrown while updating user history item", (Throwable)e);
        }
    }

    private GenericValue createHistoryItemNoChecks(@Nonnull ApplicationUser user, @Nonnull UserHistoryItem item) {
        return this.delegator.createValue(TABLE, (Map)new FieldMap().add(TYPE, (Object)item.getType().getName()).add(USER, (Object)user.getKey()).add(ENTITY_ID, (Object)item.getEntityId()).add(LAST_VIEWED, (Object)item.getLastViewed()).add(DATA, (Object)item.getData()));
    }

    public void expireOldHistoryItems(@Nonnull ApplicationUser user, @Nonnull UserHistoryItem.Type type, Collection<String> entityIds) {
        List<EntityExpr> conditions = Arrays.asList(new EntityExpr(USER, EntityOperator.EQUALS, (Object)user.getKey()), new EntityExpr(TYPE, EntityOperator.EQUALS, (Object)type.getName()), new EntityExpr(ENTITY_ID, EntityOperator.IN, entityIds));
        this.delegator.removeByCondition(TABLE, (EntityCondition)new EntityConditionList(conditions, EntityOperator.AND));
    }

    @Override
    @Nonnull
    public List<UserHistoryItem> getHistory(@Nonnull UserHistoryItem.Type type, @Nonnull String userKey) {
        Assertions.notNull((String)"userKey", (Object)userKey);
        Assertions.notNull((String)TYPE, (Object)type);
        return this.getSortedHistory(FieldMap.build((String)TYPE, (Object)type.getName(), (String)USER, (Object)userKey));
    }

    @Override
    @Nonnull
    public List<UserHistoryItem> getHistory(@Nonnull UserHistoryItem.Type type, @Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        return this.getHistory(type, user.getKey());
    }

    private List<UserHistoryItem> getSortedHistory(FieldMap fields) {
        List historyItemGVs = this.delegator.findByAnd(TABLE, (Map)fields, SORT_BY_LAST_VIEWED_DESC);
        ArrayList<UserHistoryItem> returnList = new ArrayList<UserHistoryItem>(historyItemGVs.size());
        for (GenericValue historyItemGV : historyItemGVs) {
            returnList.add(OfBizUserHistoryStore.convertGV(historyItemGV));
        }
        return returnList;
    }

    @Override
    public Set<UserHistoryItem.Type> removeHistoryForUser(@Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        Set<UserHistoryItem.Type> types = this.getDistinctHistoryItemTypes(user);
        if (!types.isEmpty()) {
            Delete.from(TABLE).whereEqual(USER, user.getKey()).execute(this.delegator);
        }
        return types;
    }

    @Override
    public void removeHistoryOlderThan(@Nonnull Long timestamp) {
        Long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp - TimeUnit.DAYS.toMillis(30L) < timestamp) {
            throw new IllegalArgumentException("Can't delete user history that is not at least 30 days old");
        }
        this.delegator.removeByCondition(TABLE, (EntityCondition)new EntityExpr(LAST_VIEWED, EntityOperator.LESS_THAN_EQUAL_TO, (Object)timestamp));
    }

    @Nonnull
    private Set<UserHistoryItem.Type> getDistinctHistoryItemTypes(@Nonnull ApplicationUser user) {
        return Select.distinctString(TYPE).from(TABLE).whereEqual(USER, user.getKey()).runWith(this.delegator).consumeWith(new TypeCollector());
    }

    private static UserHistoryItem convertGV(GenericValue historyItemGV) {
        UserHistoryItem.Type type = UserHistoryItem.Type.getInstance((String)historyItemGV.getString(TYPE));
        String entityId = historyItemGV.getString(ENTITY_ID);
        Long lastViewed = historyItemGV.getLong(LAST_VIEWED);
        String data = historyItemGV.getString(DATA);
        return new UserHistoryItem(type, entityId, lastViewed.longValue(), data);
    }

    static class TypeCollector
    implements EntityListConsumer<String, Set<UserHistoryItem.Type>> {
        final Set<UserHistoryItem.Type> types = new HashSet<UserHistoryItem.Type>(16);

        TypeCollector() {
        }

        @Override
        public void consume(String typeName) {
            this.types.add(UserHistoryItem.Type.getInstance((String)typeName));
        }

        @Override
        public Set<UserHistoryItem.Type> result() {
            return this.types;
        }
    }
}

