/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.OrderByRequest;
import com.atlassian.jira.util.OrderByRequestParser;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OrderByRequestParserImpl
implements OrderByRequestParser {
    private static final Pattern PREFIX_FIELD_PATTERN = Pattern.compile("^([+\\-]?)\\s*(.*)$");
    private final I18nHelper i18n;

    public OrderByRequestParserImpl(I18nHelper i18n) {
        this.i18n = i18n;
    }

    public <T extends Enum<T>> Either<ErrorCollection, OrderByRequest<T>> parse(String orderByValue, Class<T> fields) {
        Pair<OrderByRequest.Order, String> orderAndField = this.extractOrderAndField(orderByValue);
        OrderByRequest.Order order = (OrderByRequest.Order)orderAndField.left();
        String value = (String)orderAndField.right();
        for (Enum field : (Enum[])fields.getEnumConstants()) {
            if (!field.toString().equalsIgnoreCase(value)) continue;
            return Either.right((Object)new OrderByRequest((Object)field, order));
        }
        return Either.left((Object)new SimpleErrorCollection(this.i18n.getText("util.errors.order.query.parse", value, Arrays.toString(fields.getEnumConstants())), ErrorCollection.Reason.VALIDATION_FAILED));
    }

    private Pair<OrderByRequest.Order, String> extractOrderAndField(String orderQuery) {
        Matcher matcher = PREFIX_FIELD_PATTERN.matcher(Strings.nullToEmpty((String)orderQuery).trim());
        matcher.find();
        String prefix = matcher.group(1);
        OrderByRequest.Order order = Strings.isNullOrEmpty((String)prefix) ? OrderByRequest.Order.ASC : (prefix.equals("+") ? OrderByRequest.Order.ASC : OrderByRequest.Order.DESC);
        return Pair.pair((Object)order, (Object)matcher.group(2));
    }
}

