/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.velocity;

import com.atlassian.jira.util.velocity.RequestContextParameterHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RequestContextParameterHolderImpl
implements RequestContextParameterHolder {
    private final String servletPath;
    private final StringBuffer requestURL;
    private final String queryString;
    private final Map parameterMap;

    public RequestContextParameterHolderImpl(HttpServletRequest request) {
        if (request != null) {
            this.servletPath = request.getServletPath();
            this.requestURL = request.getRequestURL();
            this.queryString = request.getQueryString();
            this.parameterMap = Collections.unmodifiableMap(new HashMap(request.getParameterMap()));
        } else {
            this.queryString = null;
            this.servletPath = null;
            this.requestURL = null;
            this.parameterMap = null;
        }
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getRequestURL() {
        if (this.requestURL != null) {
            return this.requestURL.toString();
        }
        return null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }
}

