/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.myjirahome.MyJiraHomeLinker;
import com.atlassian.jira.security.login.LoginManagerImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.landingpage.LandingPageRedirectManager;
import com.atlassian.web.servlet.api.ServletForwarder;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class MyJiraHome
extends JiraWebActionSupport {
    private final MyJiraHomeLinker myJiraHomeLinker;
    private final UserManager userManager;
    private final LandingPageRedirectManager landingPageRedirectManager;

    public MyJiraHome(@Nonnull MyJiraHomeLinker myJiraHomeLinker, @Nonnull UserManager userManager, @Nonnull LandingPageRedirectManager landingPageRedirectManager) {
        this.myJiraHomeLinker = myJiraHomeLinker;
        this.userManager = userManager;
        this.landingPageRedirectManager = landingPageRedirectManager;
    }

    protected String doExecute() throws Exception {
        String myHome = this.findMyHome();
        if (this.canForward(myHome)) {
            return this.forward(myHome);
        }
        return this.getRedirect(myHome);
    }

    private String findMyHome() {
        ApplicationUser loggedInUser = this.getLoggedInUser();
        Optional<String> redirectUrl = this.landingPageRedirectManager.redirectUrl(loggedInUser);
        if (redirectUrl.isPresent()) {
            return redirectUrl.get();
        }
        if (loggedInUser != null) {
            return this.myJiraHomeLinker.getHomeLink(loggedInUser);
        }
        if (this.isKnownButUnauthorised()) {
            return this.myJiraHomeLinker.getDefaultUserHome();
        }
        return this.myJiraHomeLinker.getHomeLink(null);
    }

    private boolean isKnownButUnauthorised() {
        String userKeyStr;
        ApplicationUser user;
        Object userKey;
        HttpServletRequest httpRequest = this.getHttpRequest();
        return Boolean.TRUE.equals(httpRequest.getAttribute(LoginManagerImpl.AUTHORISED_FAILURE)) && (userKey = httpRequest.getAttribute(LoginManagerImpl.AUTHORISING_USER_KEY)) instanceof String && (user = this.userManager.getUserByKey(userKeyStr = (String)userKey)) != null;
    }

    private boolean canForward(String path) {
        switch (path) {
            case "/secure/Dashboard.jspa": 
            case "/secure/IssueNavigator.jspa": 
            case "/secure/GreenHopper.jspa": {
                return true;
            }
        }
        return false;
    }

    private String forward(String path) {
        ServletForwarder forwarder = (ServletForwarder)ComponentAccessor.getOSGiComponentInstanceOfType(ServletForwarder.class);
        forwarder.forward(this.getHttpRequest(), this.getHttpResponse(), URI.create(path));
        return "none";
    }
}

