/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.instrumentation.cache;

import com.atlassian.cache.CacheManager;
import com.atlassian.jira.instrumentation.InstrumentationListenerManager;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@WebSudoRequired
public class ManageCacheInstrumentation
extends JiraWebActionSupport {
    private final InstrumentationListenerManager listenerManager;
    private final CacheManager cacheManager;
    private final InstrumentationLogger instrumentationlogger;

    public ManageCacheInstrumentation(CacheManager cacheManager, InstrumentationListenerManager listenerManager, InstrumentationLogger instrumentationLogger) {
        this.cacheManager = cacheManager;
        this.listenerManager = listenerManager;
        this.instrumentationlogger = instrumentationLogger;
    }

    public List<CacheManagementBean> getCaches() {
        return this.cacheManager.getManagedCaches().stream().map(cache -> new CacheManagementBean(cache.getName())).collect(Collectors.toList());
    }

    public String getBufferCount() {
        return String.valueOf(this.instrumentationlogger.getLogEntriesFromBuffer().size());
    }

    @RequiresXsrfCheck
    public String doClearBuffer() {
        this.instrumentationlogger.clearMemoryBuffer();
        return "success";
    }

    @RequiresXsrfCheck
    public String doEnableAll() {
        this.listenerManager.applyToAllListeners(r -> r.setEnabled(true));
        return "success";
    }

    @RequiresXsrfCheck
    public String doDisableAll() {
        this.listenerManager.applyToAllListeners(r -> r.setEnabled(false));
        return "success";
    }

    class CacheManagementBean {
        private final String name;
        private boolean enabled;

        @Nonnull
        public CacheManagementBean(String name) {
            this.name = name;
            this.enabled = ManageCacheInstrumentation.this.cacheManager.getManagedCache(name).isStatisticsEnabled();
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

