/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.web.action.browser.ReportConfiguredEvent;
import com.atlassian.jira.event.web.action.browser.ReportViewedEvent;
import com.atlassian.jira.plugin.report.Report;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.seraph.util.RedirectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class ConfigureReport
extends ProjectActionSupport {
    private static final String EXCEL_VIEW = "excel";
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;
    private String reportKey;
    private ReportModuleDescriptor descriptor;
    private ObjectConfiguration oc;
    private String generatedReport;
    private Report report;

    @Deprecated
    public ConfigureReport(ProjectManager projectManager, PermissionManager permissionManager, PluginAccessor pluginAccessor) {
        this(projectManager, permissionManager, pluginAccessor, (EventPublisher)ComponentAccessor.getComponent(EventPublisher.class));
    }

    public ConfigureReport(ProjectManager projectManager, PermissionManager permissionManager, PluginAccessor pluginAccessor, EventPublisher eventPublisher) {
        super(projectManager, permissionManager);
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
    }

    public String getParamValue(String key) {
        String value;
        block3: {
            Map<String, Object> inputParams = this.makeReportParams();
            value = (String)inputParams.get(key);
            if (value == null) {
                try {
                    value = this.getObjectConfiguration().getFieldDefault(key);
                }
                catch (ObjectConfigurationException objectConfigurationException) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug((Object)String.format("The configuration property with the key: %s could not be found for the report module descriptor with the key: %s", key, this.reportKey), (Throwable)objectConfigurationException);
                }
            }
        }
        return value;
    }

    public List getParamValues(String key) {
        Map<String, Object> inputParams = this.makeReportParams();
        Object values = inputParams.get(key);
        if (values == null) {
            try {
                values = this.getObjectConfiguration().getFieldDefault(key);
            }
            catch (ObjectConfigurationException objectConfigurationException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("The configuration property with the key: %s could not be found for the report module descriptor with the key: %s", key, this.reportKey), (Throwable)objectConfigurationException);
                }
                return Collections.emptyList();
            }
        } else if (values instanceof String[]) {
            return Arrays.asList((String[])values);
        }
        return Arrays.asList(values.toString());
    }

    public String doDefault() throws Exception {
        if (!this.validReport()) {
            return "noreporterror";
        }
        this.eventPublisher.publish((Object)new ReportConfiguredEvent(this.getReportKey()));
        return super.doDefault();
    }

    protected String doExecute() throws Exception {
        if (!this.validReport()) {
            return "noreporterror";
        }
        this.getReportModule().validate((ProjectActionSupport)this, this.makeReportParams());
        if (this.getReasons().contains(ErrorCollection.Reason.NOT_LOGGED_IN)) {
            return this.forceRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)this.request));
        }
        if (this.invalidInput()) {
            return "input";
        }
        this.generatedReport = this.getReportModule().generateReportHtml((ProjectActionSupport)this, this.makeReportParams());
        this.eventPublisher.publish((Object)new ReportViewedEvent(this.getReportKey()));
        return "success";
    }

    private boolean validReport() {
        if (StringUtils.isEmpty((String)this.getReportKey())) {
            this.addErrorMessage(this.getText("report.configure.error.no.report.key"));
            return false;
        }
        if (this.getReport() == null || !this.getReportModule().showReport()) {
            this.addErrorMessage(this.getText("report.configure.error.no.report", this.getReportKey()));
            return false;
        }
        return true;
    }

    public String doExcelView() throws Exception {
        this.generatedReport = this.getReportModule().generateReportExcel((ProjectActionSupport)this, this.makeReportParams());
        return EXCEL_VIEW;
    }

    private Map<String, Object> makeReportParams() {
        Map params = ActionContext.getParameters();
        LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            if (((String[])entry.getValue()).length == 1) {
                reportParams.put(key, ((String[])entry.getValue())[0]);
                continue;
            }
            reportParams.put(key, entry.getValue());
        }
        return reportParams;
    }

    public String getQueryString() {
        Map<String, Object> params = this.makeReportParams();
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirstKey = true;
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof String) {
                isFirstKey = this.appendUrlParameter(isFirstKey, key, (String)value, stringBuilder);
                continue;
            }
            if (!(value instanceof String[])) continue;
            for (int i = 0; i < ((String[])value).length; ++i) {
                String s = ((String[])value)[i];
                isFirstKey = this.appendUrlParameter(isFirstKey, key, s, stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    private boolean appendUrlParameter(boolean firstKey, String key, String value, StringBuilder stringBuilder) {
        if (firstKey) {
            stringBuilder.append(this.encode(key)).append('=').append(this.encode(value));
        } else {
            stringBuilder.append('&').append(this.encode(key)).append('=').append(this.encode(value));
        }
        return false;
    }

    private String encode(String key) {
        return JiraUrlCodec.encode((String)key);
    }

    private Report getReportModule() {
        if (this.report == null) {
            this.report = this.getReport().getModule();
        }
        return this.report;
    }

    public String getGeneratedReport() {
        return this.generatedReport;
    }

    public String getReportKey() {
        return this.reportKey;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    public ReportModuleDescriptor getReport() {
        if (this.descriptor == null) {
            this.descriptor = (ReportModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(this.reportKey);
        }
        return this.descriptor;
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        if (this.oc == null) {
            Map objectConfigurationParameters = MapBuilder.build((Object)"project", (Object)(this.getSelectedProject() == null ? null : this.getSelectedProject().getGenericValue()), (Object)"User", (Object)this.getLoggedInUser());
            this.oc = this.getReport().getObjectConfiguration(objectConfigurationParameters);
        }
        return this.oc;
    }

    public boolean getLoginAdvisable() {
        return this.getLoggedInApplicationUser() == null && this.hasAnyErrors();
    }

    public String getLoginAdviceMessage() {
        StringBuilder loginLink = new StringBuilder("<a rel=\"nofollow\" href=\"");
        loginLink.append(RedirectUtils.getLinkLoginURL((HttpServletRequest)this.request));
        loginLink.append("\">");
        return this.getText("report.loginadvised", loginLink.toString(), "</a>");
    }

    public String getFilterProjectName(String key) {
        return this.getParamValue("projectOrFilterName");
    }
}

