/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.component.ColumnLayoutItemProvider;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class AbstractBulkOperationAction
extends IssueActionSupport {
    private final SearchService searchService;
    private final BulkEditBeanSessionHelper bulkEditBeanSessionHelper;

    public AbstractBulkOperationAction(SearchService searchService, BulkEditBeanSessionHelper bulkEditBeanSessionHelper) {
        this.searchService = searchService;
        this.bulkEditBeanSessionHelper = bulkEditBeanSessionHelper;
    }

    public BulkEditBean getBulkEditBean() {
        return this.getRootBulkEditBean();
    }

    public List getColumns() throws Exception {
        return this.getColumnsProvider().getColumns(this.getLoggedInUser(), this.getSearchRequest());
    }

    @VisibleForTesting
    ColumnLayoutItemProvider getColumnsProvider() {
        return new ColumnLayoutItemProvider();
    }

    public IssueTableLayoutBean getIssueTableLayoutBean() throws Exception {
        IssueTableLayoutBean layoutBean = new IssueTableLayoutBean(this.getColumns());
        layoutBean.setSortingEnabled(false);
        return layoutBean;
    }

    @Deprecated
    protected void clearBulkEditBean() {
        this.bulkEditBeanSessionHelper.removeFromSession();
    }

    protected String finishWizard() throws Exception {
        String returnUrl = this.getRedirectUrl();
        this.clearBulkEditBean();
        return this.getRedirect(returnUrl);
    }

    protected String watchProgress(String progressUrl) throws Exception {
        this.getRootBulkEditBean().setRedirectUrl(this.getRedirectUrl());
        return this.getRedirect(progressUrl);
    }

    public String getRedirect(String urlToActuallyGoTo) {
        String eventuallyReturnToUrl = this.getReturnUrl();
        this.setReturnUrl(null);
        this.storeReturnUrl(eventuallyReturnToUrl);
        return super.getRedirect(urlToActuallyGoTo);
    }

    protected String getRedirectUrl() throws Exception {
        String finishedUrl = null;
        BulkEditBean editBean = this.getRootBulkEditBean();
        if (editBean != null) {
            finishedUrl = editBean.getRedirectUrl();
        }
        if (StringUtils.isEmpty(finishedUrl)) {
            if (editBean != null && editBean.isSingleMode()) {
                finishedUrl = "/browse/" + editBean.getSingleIssueKey();
            } else {
                finishedUrl = "/issues/";
                SearchRequest searchRequest = this.getSearchRequest();
                if (searchRequest != null) {
                    finishedUrl = finishedUrl + "?jql=" + this.urlEncode(this.searchService.getJqlString(searchRequest.getQuery()));
                }
            }
        }
        return finishedUrl;
    }

    @Deprecated
    protected void storeBulkEditBean(BulkEditBean bulkEditBean) {
        this.bulkEditBeanSessionHelper.storeToSession(bulkEditBean);
        this.storeReturnUrl(this.getReturnUrl());
    }

    protected void storeReturnUrl(String returnUrl) {
        BulkEditBean editBean = this.getRootBulkEditBean();
        if (editBean != null && !editBean.isRedirectUrlSet()) {
            editBean.setRedirectUrl(returnUrl);
        }
    }

    @Deprecated
    public BulkEditBean getRootBulkEditBean() {
        BulkEditBean bean = this.bulkEditBeanSessionHelper.getFromSession();
        if (bean == null) {
            this.log.warn((Object)"Bulk edit bean unexpectedly null. Perhaps session was lost (e.g. when URL used is different to base URL in General Configuration)?");
        }
        return bean;
    }

    public boolean isCanDisableMailNotifications() {
        if (this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return true;
        }
        Collection projects = this.getBulkEditBean().getProjectObjects();
        for (Project project : projects) {
            if (this.hasProjectPermission(ProjectPermissions.ADMINISTER_PROJECTS, project)) continue;
            return false;
        }
        return true;
    }

    public boolean isSendBulkNotification() {
        return this.getBulkEditBean().isSendBulkNotification();
    }

    public void setSendBulkNotification(boolean sendBulkNotification) {
        if (this.getBulkEditBean() != null) {
            this.getBulkEditBean().setSendBulkNotification(sendBulkNotification);
        }
    }

    protected String redirectToStart() {
        ActionContext.getSession().put("jira.session.timeout.message", this.getText("bulk.operation.session.timeout.message"));
        return this.getRedirect("SessionTimeoutMessage.jspa");
    }
}

