/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.crowd.embedded.ofbiz.UnsortedNullRestriction;
import com.atlassian.jira.issue.comparator.UserNameComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.LazyLoadingApplicationUser;
import com.atlassian.jira.web.bean.FilterUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserBrowserFilter
extends PagerFilter<ApplicationUser> {
    private static final Logger log = LoggerFactory.getLogger(UserBrowserFilter.class);
    public static final String ANY_APPLICATION_ACCESS_FILTER = "-1";
    public static final String NO_APPLICATION_ACCESS_FILTER = "-2";
    private static final int MEMBERSHIP_CRITERIA_THRESHOLD = 1000;
    public String userSearchFilter = null;
    public String group = null;
    private final Locale userLocale;
    private final ApplicationRoleManager roleManager;
    private AccessFilterType applicationFilterType = AccessFilterType.IGNORE;
    private ApplicationKey applicationFilter = null;

    public UserBrowserFilter(Locale userLocale, ApplicationRoleManager roleManager) {
        this.userLocale = userLocale;
        this.roleManager = roleManager;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = FilterUtils.verifyString(group);
    }

    public String getUserSearchFilter() {
        return this.userSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public void setApplicationFilter(String applicationFilter) {
        this.applicationFilterType = AccessFilterType.IGNORE;
        this.applicationFilter = null;
        switch (applicationFilter) {
            case "-1": {
                this.applicationFilterType = AccessFilterType.SPECIAL_ANY;
                break;
            }
            case "-2": {
                this.applicationFilterType = AccessFilterType.SPECIAL_NONE;
                break;
            }
            default: {
                try {
                    Option role = this.roleManager.getRole(ApplicationKey.valueOf((String)applicationFilter));
                    if (!role.isDefined()) break;
                    this.applicationFilterType = AccessFilterType.REGULAR;
                    this.applicationFilter = ((ApplicationRole)role.get()).getKey();
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public String getApplicationFilter() {
        switch (this.applicationFilterType) {
            case SPECIAL_ANY: {
                return ANY_APPLICATION_ACCESS_FILTER;
            }
            case SPECIAL_NONE: {
                return NO_APPLICATION_ACCESS_FILTER;
            }
            case REGULAR: {
                return this.applicationFilter.value();
            }
        }
        return null;
    }

    public List<ApplicationUser> getFilteredUsers() throws Exception {
        Iterable users = this.getUsersFilteredByGroupAndCriteria();
        if (this.applicationFilterType != AccessFilterType.IGNORE) {
            users = Iterables.filter(users, this::includeBasedOnApplicationAccess);
        }
        ArrayList sortedUsers = Lists.newArrayList(users);
        Collections.sort(sortedUsers, new UserNameComparator(this.userLocale));
        return sortedUsers;
    }

    private Iterable<ApplicationUser> getUsersFilteredByGroupAndCriteria() {
        CrowdService crowdService = (CrowdService)ComponentAccessor.getComponentOfType(CrowdService.class);
        if (this.group != null) {
            if (Strings.isNullOrEmpty((String)this.userSearchFilter)) {
                MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(this.group).returningAtMost(-1);
                Iterable namesOfMembers = crowdService.search((Query)membershipQuery);
                return this.makeLazyApplicationUsersFromNames(namesOfMembers, crowdService);
            }
            UserQuery criteriaQuery = new UserQuery(String.class, this.makeCrowdRestriction(), 0, -1);
            Iterable criteriaResults = crowdService.search((Query)criteriaQuery);
            int criteriaResultCount = Iterables.size((Iterable)criteriaResults);
            if (criteriaResultCount > 1000) {
                MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(this.group).returningAtMost(-1);
                HashSet namesOfMembers = new HashSet();
                Stopwatch timer = Stopwatch.createStarted();
                Iterables.addAll(namesOfMembers, (Iterable)crowdService.search((Query)membershipQuery));
                log.debug("Membership query time: {}", (Object)timer);
                HashSet namesOfCriteriaMatches = new HashSet();
                Iterables.addAll(namesOfCriteriaMatches, (Iterable)criteriaResults);
                Sets.SetView namesOfFullMatches = Sets.intersection(namesOfMembers, namesOfCriteriaMatches);
                return this.makeLazyApplicationUsersFromNames((Iterable<String>)namesOfFullMatches, crowdService);
            }
            ArrayList<String> fullMatches = new ArrayList<String>();
            for (String criteriaMatchingUser : criteriaResults) {
                if (!crowdService.isUserMemberOfGroup(criteriaMatchingUser, this.group)) continue;
                fullMatches.add(criteriaMatchingUser);
            }
            return this.makeLazyApplicationUsersFromNames(fullMatches, crowdService);
        }
        UserQuery query = new UserQuery(String.class, this.makeCrowdRestriction(), 0, -1);
        Iterable userNames = crowdService.search((Query)query);
        return this.makeLazyApplicationUsersFromNames(userNames, crowdService);
    }

    private List<ApplicationUser> makeLazyApplicationUsersFromNames(Iterable<String> userNames, CrowdService crowdService) {
        ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>(Iterables.size(userNames));
        for (String userName : userNames) {
            users.add(new LazyLoadingApplicationUser(userName, crowdService));
        }
        return users;
    }

    private SearchRestriction makeCrowdRestriction() {
        ArrayList<TermRestriction> restrictions = new ArrayList<TermRestriction>();
        if (!Strings.isNullOrEmpty((String)this.userSearchFilter)) {
            restrictions.add(new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)this.userSearchFilter));
            restrictions.add(new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)this.userSearchFilter));
            restrictions.add(new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)this.userSearchFilter));
        }
        UnsortedNullRestriction restriction = restrictions.isEmpty() ? UnsortedNullRestriction.INSTANCE : new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, restrictions);
        return restriction;
    }

    private boolean includeBasedOnApplicationAccess(ApplicationUser user) {
        switch (this.applicationFilterType) {
            case REGULAR: {
                return this.roleManager.userOccupiesRole(user, this.applicationFilter);
            }
            case SPECIAL_NONE: {
                return !this.roleManager.hasAnyRole(user);
            }
            case SPECIAL_ANY: {
                return this.roleManager.hasAnyRole(user);
            }
        }
        return true;
    }

    private static enum AccessFilterType {
        SPECIAL_ANY,
        SPECIAL_NONE,
        REGULAR,
        IGNORE;

    }
}

