/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean.i18n;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.web.bean.i18n.CompressedKeyStore;
import com.atlassian.jira.web.bean.i18n.StringBackedStore;
import com.atlassian.jira.web.bean.i18n.TranslationStore;
import com.atlassian.jira.web.bean.i18n.TranslationStoreFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DefaultTranslationStoreFactory
implements TranslationStoreFactory {
    @VisibleForTesting
    static String COMPRESS_I18N_PROPERTY = "jira.i18n.compress";
    private final JiraProperties properties;

    public DefaultTranslationStoreFactory(JiraProperties properties) {
        this.properties = properties;
    }

    @Override
    public TranslationStore createTranslationStore(Map<String, String> bundles) {
        boolean compress = false;
        String compressOverride = this.properties.getProperty(COMPRESS_I18N_PROPERTY);
        if (StringUtils.isNotBlank((String)compressOverride)) {
            compress = Boolean.valueOf(compressOverride);
        }
        return compress ? new CompressedKeyStore(bundles) : new StringBackedStore(bundles);
    }
}

