/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.bc.security.login.DeniedReason;
import com.atlassian.jira.bc.security.login.LoginResult;
import com.atlassian.jira.web.dispatcher.JiraWebworkActionDispatcher;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class DisplayErrorServlet
extends JiraWebworkActionDispatcher {
    private static final String STATUS_CODE = "javax.servlet.error.status_code";
    private ServletConfig config;

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response = (HttpServletResponse)res;
        Integer code = (Integer)req.getAttribute(STATUS_CODE);
        if (code == null) {
            code = 404;
        } else if (code == 401 && req.getAttribute("com.atlassian.jira.security.login.LoginManager.LoginResult") instanceof LoginResult) {
            LoginResult result = (LoginResult)req.getAttribute("com.atlassian.jira.security.login.LoginManager.LoginResult");
            for (DeniedReason reason : result.getDeniedReasons()) {
                code = 403;
                response.setHeader("X-Authentication-Denied-Reason", reason.asString());
            }
        }
        response.setStatus(code.intValue());
        req.setAttribute(STATUS_CODE, (Object)code);
        req.getRequestDispatcher("/displayError.jsp").forward(req, res);
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        this.config = config;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void destroy() {
    }
}

