/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.encoding.AbstractEncodingFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class JiraEncodingFilter
extends AbstractEncodingFilter {
    private static final String DEFAULT_CONTENT_TYPE = "text/html; charset=UTF-8";
    private static final String IMAGE = "image";

    protected String getEncoding() {
        return JiraEncodingFilter.getApplicationProperties().map(ApplicationProperties::getEncoding).orElse("UTF-8");
    }

    protected String getContentType() {
        try {
            String mimeType;
            String url;
            HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
            if (null != httpServletRequest && !StringUtils.isBlank((CharSequence)(url = httpServletRequest.getRequestURI())) && StringUtils.startsWith((CharSequence)(mimeType = (String)ComponentAccessor.getComponentSafely(MimeManager.class).map(mimeManager -> mimeManager.getSuggestedMimeType(url)).orElse(null)), (CharSequence)IMAGE)) {
                return mimeType;
            }
            return JiraEncodingFilter.getApplicationProperties().map(ApplicationProperties::getContentType).orElse(DEFAULT_CONTENT_TYPE);
        }
        catch (Exception e) {
            return DEFAULT_CONTENT_TYPE;
        }
    }

    private static Optional<ApplicationProperties> getApplicationProperties() {
        return ComponentAccessor.getComponentSafely(ApplicationProperties.class);
    }
}

