/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.mau.LastSentKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MauEventFilter
extends AbstractHttpFilter {
    public static final String MAU_FEATURE_LOGGING = "jira.event.mau.logging";
    private static final String MAU_IGNORE_HEADER = "x-atlassian-mau-ignore";
    private static final Logger LOGGER = LoggerFactory.getLogger(MauEventFilter.class);
    private ComponentReference<MauEventService> mauEventService = ComponentAccessor.getComponentReference(MauEventService.class);
    private ComponentReference<FeatureManager> featureManager = ComponentAccessor.getComponentReference(FeatureManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Optional<String> ignoreMauEvent = Optional.ofNullable(request.getHeader(MAU_IGNORE_HEADER));
            if (!ignoreMauEvent.isPresent()) {
                this.getMauEventService().ifPresent(service -> {
                    service.triggerEvent();
                    boolean shouldLogMau = false;
                    if (this.getFeatureManager().isPresent()) {
                        shouldLogMau = this.getFeatureManager().get().isEnabled(MAU_FEATURE_LOGGING);
                    }
                    LastSentKey key = service.getKeyWithCurrentApplication();
                    if (shouldLogMau && key != null && LOGGER.isInfoEnabled()) {
                        LOGGER.info("MAU registered to '{}' by '{}'", (Object)key.getApplicationKey().getKey(), (Object)key.getUserId());
                    }
                });
            }
        }
    }

    @VisibleForTesting
    Optional<MauEventService> getMauEventService() {
        return Optional.ofNullable(this.mauEventService.get());
    }

    @VisibleForTesting
    Optional<FeatureManager> getFeatureManager() {
        return Optional.ofNullable(this.featureManager.get());
    }
}

