/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.johnson;

import com.atlassian.jira.web.startup.StartupPageSupport;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.filters.AbstractJohnsonFilter;
import com.atlassian.johnson.setup.SetupConfig;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraJohnsonFilter
extends AbstractJohnsonFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JiraJohnsonFilter.class);
    private static final String ALREADY_FILTERED = JiraJohnsonFilter.class.getName() + "_already_filtered";

    public static String getServletPathFromRequest(HttpServletRequest request) {
        return JiraJohnsonFilter.getServletPath((HttpServletRequest)request);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        boolean intercepted = false;
        if (request.getAttribute(ALREADY_FILTERED) == null) {
            request.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
            intercepted = new Interceptor((HttpServletRequest)request, (HttpServletResponse)response).intercept();
        }
        if (!intercepted) {
            filterChain.doFilter(request, response);
        }
    }

    protected void handleError(JohnsonEventContainer container, HttpServletRequest request, HttpServletResponse response) throws IOException {
        JiraJohnsonFilter.redirect(request, response, "JIRA currently has application level errors.", this.config.getErrorPath());
    }

    protected void handleNotSetup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JiraJohnsonFilter.redirect(request, response, "JIRA has not been configured, yet.", this.config.getSetupPath());
    }

    static void redirect(HttpServletRequest request, HttpServletResponse response, String message, String targetPath) throws IOException {
        String contextPath = request.getContextPath();
        LOG.debug("{} Redirecting request from '{}' to '{}'", new Object[]{message, JiraJohnsonFilter.getServletPath((HttpServletRequest)request), targetPath});
        response.sendRedirect(contextPath + targetPath);
    }

    class Interceptor {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final String servletPath;
        private final JohnsonEventContainer container;
        private Boolean filtered;

        Interceptor(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
            this.servletPath = JiraJohnsonFilter.getServletPath((HttpServletRequest)request);
            this.container = JiraJohnsonFilter.this.getContainerAndRunEventChecks(request);
        }

        boolean intercept() throws IOException {
            return this.interceptErrors() || this.interceptStartup() || this.interceptSetup();
        }

        private boolean interceptStartup() throws IOException {
            if (StartupPageSupport.isLaunched()) {
                return false;
            }
            if (StartupPageSupport.isStartupPage(this.request)) {
                throw new IllegalStateException("StartupProgressFilter should have terminated the filter chain!");
            }
            StartupPageSupport.redirectToStartupPage(this.request, this.response);
            return true;
        }

        private boolean isJohnsonFilteredPage() {
            if (this.filtered == null) {
                this.filtered = !JiraJohnsonFilter.this.ignoreURI(this.servletPath);
            }
            return this.filtered;
        }

        private boolean interceptErrors() throws IOException {
            if (this.container.hasEvents() && this.isJohnsonFilteredPage()) {
                JiraJohnsonFilter.this.handleError(this.container, this.request, this.response);
                return true;
            }
            return false;
        }

        private boolean interceptSetup() throws IOException {
            SetupConfig setup = JiraJohnsonFilter.this.config.getSetupConfig();
            if (setup.isSetup() || setup.isSetupPage(this.servletPath) || !this.isJohnsonFilteredPage()) {
                return false;
            }
            JiraJohnsonFilter.this.handleNotSetup(this.request, this.response);
            return true;
        }
    }
}

