/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.instrumentation;

import com.atlassian.instrumentation.Gauge;
import com.atlassian.instrumentation.InstrumentRegistry;
import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.instrumentation.operations.OpTimerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.instrumentation.DefaultInstrumentationListenerManager;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;
import com.atlassian.jira.web.filters.steps.NullFilterStep;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class InstrumentationStep
implements FilterStep {
    private static final String X_B3_TRACE_ID = "X-B3-TraceId";
    private static final String X_B3_SPAN_ID = "X-B3-SpanId";
    private static final String X_B3_PARENT_SPAN_ID = "X-B3-ParentSpanId";
    private final InstrumentRegistry registry;
    private final Gauge concurrentRequestsGauge;
    private OpTimer requestTimer;

    public static FilterStep create() {
        return ComponentAccessor.getComponentSafely(InstrumentRegistry.class).map(InstrumentationStep::new).orElseGet(NullFilterStep::new);
    }

    private InstrumentationStep(InstrumentRegistry registry) {
        this.registry = registry;
        this.concurrentRequestsGauge = registry.pullGauge(InstrumentationName.CONCURRENT_REQUESTS.getInstrumentName());
    }

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext callContext) {
        this.requestTimer = this.registry.pullTimer(InstrumentationName.WEB_REQUESTS.getInstrumentName());
        this.concurrentRequestsGauge.incrementAndGet();
        String traceId = callContext.getHttpServletRequest().getHeader(X_B3_TRACE_ID);
        String spanId = callContext.getHttpServletRequest().getHeader(X_B3_SPAN_ID);
        String parentSpanId = callContext.getHttpServletRequest().getHeader(X_B3_PARENT_SPAN_ID);
        DefaultInstrumentationListenerManager.startContext(callContext.getHttpServletRequest().getRequestURI(), traceId, spanId, parentSpanId);
        return callContext;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext callContext) {
        this.concurrentRequestsGauge.decrementAndGet();
        OpSnapshot time = this.requestTimer.end();
        DefaultInstrumentationListenerManager.endContext(Optional.of(time.getElapsedTotalTime(TimeUnit.NANOSECONDS)));
        ComponentAccessor.getComponentSafely(OpTimerFactory.class).ifPresent(Instrumentation::snapshotThreadLocalOperationsAndClear);
        return callContext;
    }
}

