/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.session.currentusers;

import com.atlassian.jira.util.http.HttpRequestType;
import com.atlassian.jira.web.filters.accesslog.AccessLogIPAddressUtil;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

class MutableJiraUserSession
implements JiraUserSession {
    private final AtomicLong requestCount;
    private final AtomicReference<String> userName;
    private final AtomicReference<String> ipAddress;
    private final AtomicReference<Date> lastAccessTime;
    private final AtomicReference<Date> creationTime;
    private final HttpRequestType type;
    private final String asessionId;
    private final String sessionId;

    MutableJiraUserSession(HttpRequestType type, String sessionId, String asessionId) {
        this(type, sessionId, asessionId, null);
    }

    MutableJiraUserSession(HttpRequestType type, String sessionId, String asessionId, String userName) {
        this.type = type;
        this.sessionId = sessionId;
        this.asessionId = asessionId;
        this.requestCount = new AtomicLong(0L);
        this.userName = new AtomicReference<String>(userName);
        this.ipAddress = new AtomicReference();
        this.lastAccessTime = new AtomicReference<Date>(new Date());
        this.creationTime = new AtomicReference<Date>(new Date());
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Override
    public String getASessionId() {
        return this.asessionId;
    }

    @Override
    public long getRequestCount() {
        return this.requestCount.get();
    }

    @Override
    public String getUserName() {
        return this.userName.get();
    }

    @Override
    public HttpRequestType getType() {
        return this.type;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress.get();
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime.get();
    }

    @Override
    public Date getLastAccessTime() {
        return this.lastAccessTime.get();
    }

    void recordInteraction(HttpServletRequest httpServletRequest, String userName) {
        this.requestCount.incrementAndGet();
        this.lastAccessTime.set(new Date());
        this.ipAddress.set(AccessLogIPAddressUtil.getRemoteAddr(httpServletRequest));
        this.userName.set(userName);
    }
}

