/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.annotations.VisibleForTesting;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.text.StrTokenizer;
import webwork.view.taglib.WebWorkTagSupport;

public class WebResourceRequireTag
extends WebWorkTagSupport {
    private String modules;
    private String contexts;

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public int doEndTag() throws JspException {
        this.includeResourcesDefinedInModules();
        this.includeResourcesDefinedInContexts();
        return super.doEndTag();
    }

    private void includeResourcesDefinedInModules() {
        StrTokenizer csvTokenizer = StrTokenizer.getCSVInstance((String)this.modules);
        while (csvTokenizer.hasNext()) {
            String aRequiredWebResourceModule = csvTokenizer.nextToken();
            this.getWebResourceManager().requireResource(aRequiredWebResourceModule);
        }
    }

    private void includeResourcesDefinedInContexts() {
        StrTokenizer csvTokenizer = StrTokenizer.getCSVInstance((String)this.contexts);
        while (csvTokenizer.hasNext()) {
            String aRequiredWebResourceContext = csvTokenizer.nextToken();
            this.getWebResourceManager().requireResourcesForContext(aRequiredWebResourceContext);
        }
    }

    @VisibleForTesting
    protected WebResourceManager getWebResourceManager() {
        return (WebResourceManager)ComponentAccessor.getComponent(WebResourceManager.class);
    }
}

