/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.gzipfilter.org.apache.commons.lang.SystemUtils;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrettyObjectPrinter {
    private static final Logger log = LoggerFactory.getLogger(PrettyObjectPrinter.class);
    private final Object object;
    private final String indentationString;
    private Writer currentWriter;

    public PrettyObjectPrinter(Object object) {
        this.object = object;
        this.indentationString = "\t";
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.prettyDump(writer);
        return writer.toString();
    }

    public void prettyDump(Writer writer) {
        this.currentWriter = writer;
        this.dumpObject(this.object, 1);
        this.currentWriter = null;
    }

    private PrettyObjectPrinter indent(int level) {
        this.write(this.indentationText(level));
        return this;
    }

    private String indentationText(int level) {
        return StringUtils.repeat((String)this.indentationString, (int)level);
    }

    private PrettyObjectPrinter nl() {
        this.write(SystemUtils.LINE_SEPARATOR);
        return this;
    }

    private PrettyObjectPrinter write(String ... val) {
        try {
            for (String s : val) {
                this.currentWriter.write(s);
            }
        }
        catch (IOException e) {
            log.warn("Cannot dump object", (Throwable)e);
        }
        return this;
    }

    private void dumpObject(Object value, int indentation) {
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                this.write("{ }");
            } else {
                this.write("{").nl();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.indent(indentation);
                    this.write((String)entry.getKey(), " = ").dumpObject(entry.getValue(), indentation + 1);
                    this.write(",").nl();
                }
                this.indent(indentation - 1).write("}");
            }
        } else if (value instanceof Iterable) {
            Iterable iter = (Iterable)value;
            if (Iterables.isEmpty((Iterable)iter)) {
                this.write("[ ]");
            } else {
                this.write("[").nl();
                for (Object o : (Iterable)value) {
                    this.indent(indentation);
                    this.dumpObject(o, indentation + 1);
                    this.write(",").nl();
                }
                this.indent(indentation - 1).write("]");
            }
        } else if (value == null) {
            this.write("(null)");
        } else {
            String str = value.toString();
            this.write(str.replace(SystemUtils.LINE_SEPARATOR, SystemUtils.LINE_SEPARATOR + "[^]" + this.indentationText(indentation)));
        }
    }
}

