/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.tabs;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.tabs.WorkflowTransitionTabProvider;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class WebPanelWorkflowTransitionTabProvider
implements WorkflowTransitionTabProvider {
    private static final String TAB_PANELS_LOCATION = "workflow.transition.tabs";
    private final WebInterfaceManager webInterfaceManager;

    public WebPanelWorkflowTransitionTabProvider(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = (WebInterfaceManager)Preconditions.checkNotNull((Object)webInterfaceManager);
    }

    @Override
    public Iterable<WorkflowTransitionTabProvider.WorkflowTransitionTab> getTabs(ActionDescriptor action, JiraWorkflow workflow) {
        Map<String, Object> context = this.createContext(action, workflow);
        Iterable<WebPanelModuleDescriptor> panels = this.getDisplayableWebPanelDescriptors(context);
        return ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.filter((Iterable)com.google.common.collect.Iterables.transform(panels, input -> (WorkflowTransitionTabProvider.WorkflowTransitionTab)SafePluginPointAccess.call(() -> {
            String label = input.getWebLabel().getDisplayableLabel(ExecutingHttpRequest.get(), context);
            String count = input.getWebParams().getRenderedParam("count", (Map)Maps.newHashMap((Map)context));
            return new WorkflowTransitionTabProvider.WorkflowTransitionTab(label, count, (WebPanelModuleDescriptor)input);
        }).getOrNull()), (Predicate)Predicates.notNull()));
    }

    private Map<String, Object> createContext(ActionDescriptor action, JiraWorkflow workflow) {
        ImmutableMap.Builder context = ImmutableMap.builder().putAll(DefaultWebFragmentContext.get((String)TAB_PANELS_LOCATION));
        if (action != null) {
            context.put((Object)"workflow_transition", (Object)action);
        }
        if (workflow != null) {
            context.put((Object)"workflow", (Object)workflow);
        }
        return context.build();
    }

    @Override
    @Nullable
    public String getTabContentHtml(String panelKey, ActionDescriptor action, JiraWorkflow workflow) {
        Map<String, Object> context = this.createContext(action, workflow);
        Iterable<WebPanelModuleDescriptor> panels = this.getDisplayableWebPanelDescriptors(context);
        Option tabDescriptor = Iterables.findFirst(panels, input -> Objects.equal((Object)input.getKey(), (Object)panelKey));
        return (String)com.google.common.collect.Iterables.getFirst((Iterable)SafePluginPointAccess.to().descriptors((Iterable)tabDescriptor, (moduleDescriptor, module) -> ((WebPanel)moduleDescriptor.getModule()).getHtml(context)), null);
    }

    private Iterable<WebPanelModuleDescriptor> getDisplayableWebPanelDescriptors(Map<String, Object> context) {
        return com.google.common.collect.Iterables.filter((Iterable)((Iterable)SafePluginPointAccess.call(() -> this.webInterfaceManager.getDisplayableWebPanelDescriptors(TAB_PANELS_LOCATION, context)).getOrElse(Collections.emptyList())), (Predicate)Predicates.notNull());
    }
}

