/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Locale;

public class SearchTokenizer {
    final ImmutableSet.Builder<String> tokens = ImmutableSet.builder();

    public String getTokenizedString() {
        return Joiner.on((String)" ").join(this.getTokens());
    }

    @VisibleForTesting
    ImmutableSet<String> getTokens() {
        return this.tokens.build();
    }

    public SearchTokenizer put(String stringToTokenize) {
        if (stringToTokenize != null) {
            this.tokens.addAll(Iterables.transform((Iterable)Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)stringToTokenize), (Function)new Function<String, String>(){

                public String apply(String input) {
                    return input.toLowerCase(Locale.ENGLISH);
                }
            }));
        }
        return this;
    }

    public static ImmutableSet<String> tokenize(String stringToTokenize) {
        return new SearchTokenizer().put(stringToTokenize).getTokens();
    }
}

