/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.activeobjects.spi.ActiveObjectsImportExportException;
import com.atlassian.activeobjects.spi.Backup;
import com.atlassian.activeobjects.spi.NullBackupProgressMonitor;
import com.atlassian.core.util.DataUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.action.admin.export.EntitiesExporter;
import com.atlassian.jira.action.admin.export.EntityXmlWriter;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.dataimport.EntityImportExportExclusions;
import com.atlassian.jira.bc.dataimport.ExportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ExportFailedEvent;
import com.atlassian.jira.bc.dataimport.ExportService;
import com.atlassian.jira.bc.dataimport.ExportStartedEvent;
import com.atlassian.jira.bc.dataimport.ExportSuccessfulEvent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExportService
implements ExportService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExportService.class);
    public static final String ACTIVEOBJECTS_XML = "activeobjects.xml";
    public static final String ENTITIES_XML = "entities.xml";
    private final DelegatorInterface genericDelegator;
    private final EntitiesExporter entitiesExporter;
    private final I18nHelper.BeanFactory i18nFactory;
    private final EventPublisher eventPublisher;
    private final JiraProperties jiraSystemProperties;

    public DefaultExportService(DelegatorInterface genericDelegator, EntitiesExporter entitiesExporter, I18nHelper.BeanFactory i18nFactory, EventPublisher eventPublisher, JiraProperties jiraSystemProperties) {
        this.genericDelegator = genericDelegator;
        this.entitiesExporter = entitiesExporter;
        this.i18nFactory = i18nFactory;
        this.eventPublisher = eventPublisher;
        this.jiraSystemProperties = jiraSystemProperties;
    }

    @Override
    public ServiceOutcome<Void> export(ApplicationUser loggedInUser, String filename, TaskProgressSink taskProgressSink) {
        return this.export(loggedInUser, filename, ExportService.Style.NORMAL, taskProgressSink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ServiceOutcome<Void> export(ApplicationUser loggedInUser, String filename, ExportService.Style style, TaskProgressSink taskProgressSink) {
        long xmlExportTime = System.currentTimeMillis();
        this.publishExportStart(loggedInUser, filename, xmlExportTime);
        I18nHelper i18n = this.i18nFactory.getInstance(loggedInUser);
        ZipArchiveOutputStream zip = null;
        try {
            zip = this.getZipOutputStream(filename);
            try {
                zip.setUseZip64(Zip64Mode.AsNeeded);
                zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(ENTITIES_XML));
                this.exportJIRA(loggedInUser, style, (OutputStream)zip);
                zip.closeArchiveEntry();
                zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(ACTIVEOBJECTS_XML));
                this.exportActiveObjects((OutputStream)zip);
                zip.closeArchiveEntry();
                ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.ok(null);
                this.publishExportSuccess(loggedInUser, filename, xmlExportTime, outcome);
                ServiceOutcomeImpl<Object> serviceOutcomeImpl = outcome;
                return serviceOutcomeImpl;
            }
            catch (GenericEntityException e) {
                block11: {
                    if (e.getMessage() == null || !e.getMessage().contains("invalid XML character")) break block11;
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                    errorCollection.addErrorMessage(i18n.getText("admin.export.backup.data.invalid.characters"), ErrorCollection.Reason.VALIDATION_FAILED);
                    ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
                    this.publishExportFailure(loggedInUser, filename, xmlExportTime, outcome, ExportFailedEvent.Reason.INVALID_XML);
                    ServiceOutcomeImpl<Object> serviceOutcomeImpl = outcome;
                    IOUtils.closeQuietly((OutputStream)zip);
                    return serviceOutcomeImpl;
                }
                LOG.error("Error during XML backup.", (Throwable)e);
                ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.errors.dataexport.error.exporting.data", (Object)e));
                this.publishExportFailure(loggedInUser, filename, xmlExportTime, outcome, ExportFailedEvent.Reason.GENERIC);
                ServiceOutcomeImpl<Void> serviceOutcomeImpl = outcome;
                IOUtils.closeQuietly((OutputStream)zip);
                return serviceOutcomeImpl;
            }
            catch (ActiveObjectsImportExportException e) {
                LOG.error("Error during Active Objects Backup", (Throwable)e);
                ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.export.backup.activeobjects.exception", e.getPluginInformation().getPluginName()));
                this.publishExportFailure(loggedInUser, filename, xmlExportTime, outcome, ExportFailedEvent.Reason.ACTIVE_OBJECTS);
                ServiceOutcomeImpl<Void> serviceOutcomeImpl = outcome;
                IOUtils.closeQuietly((OutputStream)zip);
                return serviceOutcomeImpl;
                {
                    catch (IOException e2) {
                        LOG.error("Error during XML backup.", (Throwable)e2);
                        outcome = ServiceOutcomeImpl.error(i18n.getText("admin.errors.export.ioerror", filename));
                        this.publishExportFailure(loggedInUser, filename, xmlExportTime, outcome, ExportFailedEvent.Reason.IO);
                        ServiceOutcomeImpl<Void> serviceOutcomeImpl2 = outcome;
                        return serviceOutcomeImpl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceOutcome<Void> exportForDevelopment(ApplicationUser loggedInUser, String xmlFilename, TaskProgressSink taskProgressSink) {
        ExportService.Style style = ExportService.Style.NORMAL;
        I18nHelper i18n = this.i18nFactory.getInstance(loggedInUser);
        long xmlExportTime = System.currentTimeMillis();
        this.publishExportStart(loggedInUser, xmlFilename, xmlExportTime);
        OutputStream xml = null;
        try {
            xml = this.getXmlOutputStream(xmlFilename);
            try {
                this.exportJIRA(loggedInUser, style, xml);
                ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.ok(null);
                this.publishExportSuccess(loggedInUser, xmlFilename, xmlExportTime, outcome);
                ServiceOutcomeImpl<Object> serviceOutcomeImpl = outcome;
                return serviceOutcomeImpl;
            }
            catch (GenericEntityException e) {
                ServiceOutcomeImpl<Void> serviceOutcomeImpl;
                block9: {
                    if (e.getMessage() == null || !e.getMessage().contains("invalid XML character")) break block9;
                    SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                    errorCollection.addErrorMessage(i18n.getText("admin.export.backup.data.invalid.characters"), ErrorCollection.Reason.VALIDATION_FAILED);
                    ServiceOutcomeImpl<Object> outcome = ServiceOutcomeImpl.from((ErrorCollection)errorCollection, null);
                    this.publishExportFailure(loggedInUser, xmlFilename, xmlExportTime, outcome, ExportFailedEvent.Reason.INVALID_XML);
                    ServiceOutcomeImpl<Object> serviceOutcomeImpl2 = outcome;
                    IOUtils.closeQuietly((OutputStream)xml);
                    return serviceOutcomeImpl2;
                }
                try {
                    ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.errors.dataexport.error.exporting.data", (Object)e));
                    this.publishExportFailure(loggedInUser, xmlFilename, xmlExportTime, outcome, ExportFailedEvent.Reason.GENERIC);
                    serviceOutcomeImpl = outcome;
                }
                catch (IOException e2) {
                    LOG.error("Error during XML backup.", (Throwable)e2);
                    ServiceOutcomeImpl<Void> outcome = ServiceOutcomeImpl.error(i18n.getText("admin.errors.export.ioerror", xmlFilename));
                    this.publishExportFailure(loggedInUser, xmlFilename, xmlExportTime, outcome, ExportFailedEvent.Reason.IO);
                    ServiceOutcomeImpl<Void> serviceOutcomeImpl3 = outcome;
                    return serviceOutcomeImpl3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)xml);
                return serviceOutcomeImpl;
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)xml);
        }
    }

    private void publishExportStart(ApplicationUser loggedInUser, String xmlFilename, long xmlExportTime) {
        this.eventPublisher.publish((Object)new ExportStartedEvent(loggedInUser, xmlFilename, Long.valueOf(xmlExportTime)));
    }

    private void publishExportSuccess(ApplicationUser loggedInUser, String xmlFilename, long xmlExportTime, ServiceOutcomeImpl<Void> outcome) {
        this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, xmlFilename, outcome, Long.valueOf(xmlExportTime)));
        this.eventPublisher.publish((Object)new ExportSuccessfulEvent(xmlExportTime, System.currentTimeMillis() - xmlExportTime));
    }

    private void publishExportFailure(ApplicationUser loggedInUser, String xmlFilename, long xmlExportTime, ServiceOutcomeImpl<Void> outcome, ExportFailedEvent.Reason reason) {
        this.eventPublisher.publish((Object)new ExportCompletedEvent(loggedInUser, xmlFilename, outcome, Long.valueOf(xmlExportTime)));
        this.eventPublisher.publish((Object)new ExportFailedEvent(xmlExportTime, System.currentTimeMillis() - xmlExportTime, reason));
    }

    private void exportJIRA(ApplicationUser loggedInUser, ExportService.Style style, OutputStream out) throws GenericEntityException, IOException {
        TreeSet<String> entityNames = this.entitiesToExport();
        int numberOfEntities = entityNames.size();
        LOG.debug("numberOfEntities = " + numberOfEntities);
        EntityXmlWriter entityWriter = style.getEntityXmlWriter();
        long start = System.currentTimeMillis();
        long entitiesWritten = this.entitiesExporter.exportEntities(out, entityNames, entityWriter, loggedInUser);
        LOG.info("Data export completed in " + (System.currentTimeMillis() - start) + "ms. Wrote " + entitiesWritten + " entities to export in memory.");
    }

    private void exportActiveObjects(OutputStream out) throws IOException {
        Backup activeObjects = this.getActiveObjectsBackup();
        if (activeObjects == null) {
            LOG.error("Could not find ActiveObjects in OSGi fairy land. Plugins using ActiveObjects have not been backed up.");
        } else {
            LOG.info("Attempting to save the Active Objects Backup");
            try {
                activeObjects.save(out, NullBackupProgressMonitor.INSTANCE);
            }
            catch (NoSuchMethodError ex) {
                String javaRuntimeVersion = this.jiraSystemProperties.getProperty("java.runtime.version");
                String message = "Error exporting Active Objects. You must run JRE 1.6_18 or higher. java.runtime.version: " + javaRuntimeVersion;
                LOG.error(message, (Throwable)ex);
                throw new NoSuchMethodError(message);
            }
            LOG.info("Finished saving the Active Objects Backup");
        }
    }

    protected Backup getActiveObjectsBackup() {
        return (Backup)ComponentAccessor.getOSGiComponentInstanceOfType(Backup.class);
    }

    protected ZipArchiveOutputStream getZipOutputStream(String filename) throws IOException {
        String zipFileName = DataUtils.getZipFilename((String)filename);
        File zipFile = new File(zipFileName);
        FileUtils.openOutputStream((File)zipFile).close();
        return new ZipArchiveOutputStream(zipFile);
    }

    protected OutputStream getXmlOutputStream(String filename) throws IOException {
        String xmlFileName = DataUtils.getXmlFilename((String)filename);
        return FileUtils.openOutputStream((File)new File(xmlFileName));
    }

    private TreeSet<String> entitiesToExport() throws GenericEntityException {
        ModelReader reader = this.genericDelegator.getModelReader();
        return Sets.newTreeSet((Iterable)Sets.difference((Set)Sets.newHashSet((Iterable)reader.getEntityNames()), EntityImportExportExclusions.ENTITIES_EXCLUDED_FROM_IMPORT_EXPORT));
    }
}

