/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group.search;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.GroupComparator;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.user.util.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class GroupPickerSearchServiceImpl
implements GroupPickerSearchService {
    private UserManager userManager;

    public GroupPickerSearchServiceImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    public List<Group> findGroups(String query) {
        TreeSet<Group> matchingGroups = new TreeSet<Group>(GroupComparator.GROUP_COMPARATOR);
        TreeSet<Group> exactMatches = new TreeSet<Group>(GroupComparator.GROUP_COMPARATOR);
        Collection groups = this.userManager.getGroups();
        if (StringUtils.isBlank((CharSequence)query)) {
            matchingGroups.addAll(groups);
            return new ArrayList<Group>(matchingGroups);
        }
        for (Group group : groups) {
            if (group.getName().equalsIgnoreCase(query)) {
                exactMatches.add(group);
                continue;
            }
            if (!group.getName().contains(query)) continue;
            matchingGroups.add(group);
        }
        ArrayList<Group> ret = new ArrayList<Group>();
        ret.addAll(exactMatches);
        ret.addAll(matchingGroups);
        return ret;
    }

    public Group getGroupByName(String groupName) {
        return this.userManager.getGroup(groupName);
    }
}

