/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@EventComponent
public class CachingProjectComponentStore
implements ProjectComponentStore,
Startable {
    private static final String UPDATE_LOCK_NAME = CachingProjectComponentStore.class.getName() + ".updateLock";
    private ClusterLock updateLock;
    private final Cache<Long, Optional<ProjectComponent>> componentIdToComponentMap;
    private final Cache<Long, Collection<ProjectComponent>> projectIdToComponentsMap;
    private final ProjectComponentStore delegateStore;
    private final ClusterLockService clusterLockService;

    public CachingProjectComponentStore(ProjectComponentStore delegateStore, ClusterLockService clusterLockService, CacheManager cacheManager) {
        this.delegateStore = delegateStore;
        this.clusterLockService = clusterLockService;
        this.componentIdToComponentMap = cacheManager.getCache(CachingProjectComponentStore.class.getName() + ".componentIdToComponentMap", this::loadComponentById);
        this.projectIdToComponentsMap = cacheManager.getCache(CachingProjectComponentStore.class.getName() + ".projectIdToComponentsMap", this::loadComponentsByProjectId);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.projectIdToComponentsMap.removeAll();
        this.componentIdToComponentMap.removeAll();
    }

    public void start() {
        this.updateLock = this.clusterLockService.getLockForName(UPDATE_LOCK_NAME);
    }

    @Override
    public MutableProjectComponent find(Long id) throws EntityNotFoundException {
        Assertions.notNull((String)"id", (Object)id);
        return ((Optional)this.componentIdToComponentMap.get((Object)id)).map(MutableProjectComponent::copy).orElseThrow(() -> new EntityNotFoundException("The component with id '" + id + "' does not exist."));
    }

    @Override
    public ProjectComponent getProjectComponent(Long projectComponentId) {
        Assertions.notNull((String)"id", (Object)projectComponentId);
        Optional cacheObject = (Optional)this.componentIdToComponentMap.get((Object)projectComponentId);
        return cacheObject.orElse(null);
    }

    @Override
    public Collection<MutableProjectComponent> findAllForProject(Long projectId) {
        Collection components = (Collection)this.projectIdToComponentsMap.get((Object)projectId);
        return MutableProjectComponent.copy((Collection)components);
    }

    @Override
    public MutableProjectComponent findByComponentName(Long projectId, String componentName) throws EntityNotFoundException {
        Collection<MutableProjectComponent> components = this.findAllForProject(projectId);
        for (MutableProjectComponent c : components) {
            if (!c.getName().equals(componentName)) continue;
            return c;
        }
        throw new EntityNotFoundException("The project with id '" + projectId + "' is not associated with a component with the name '" + componentName + "'.");
    }

    @Override
    public Collection<MutableProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        return this.findAll().stream().filter(component -> component.getName().equalsIgnoreCase(componentName)).map(MutableProjectComponent::copy).collect(Collectors.toList());
    }

    @Override
    public Long findProjectIdForComponent(Long componentId) throws EntityNotFoundException {
        return ((ProjectComponent)((Optional)this.componentIdToComponentMap.get((Object)componentId)).orElseThrow(() -> new EntityNotFoundException("The component with the id '" + componentId + "' does not exist."))).getProjectId();
    }

    @Override
    public boolean containsName(String name, Long projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Component project ID can not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Component name can not be null!");
        }
        Collection components = (Collection)this.projectIdToComponentsMap.get((Object)projectId);
        return CachingProjectComponentStore.containsNameIgnoreCase(components, name);
    }

    private static boolean containsNameIgnoreCase(Collection<ProjectComponent> components, String name) {
        return components != null && components.stream().filter(component -> name.equalsIgnoreCase(component.getName())).findAny().isPresent();
    }

    @Override
    public MutableProjectComponent store(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        MutableProjectComponent copy = MutableProjectComponent.copy((ProjectComponent)component);
        MutableProjectComponent newComponent = copy.getId() == null ? this.insert(copy) : this.update(copy);
        return newComponent;
    }

    @Override
    public void delete(Long componentId) throws EntityNotFoundException {
        MutableProjectComponent component = null;
        if (componentId != null) {
            component = this.delegateStore.find(componentId);
        }
        this.delegateStore.delete(componentId);
        if (componentId != null) {
            this.componentIdToComponentMap.remove((Object)componentId);
        }
        if (component != null) {
            this.projectIdToComponentsMap.remove((Object)component.getProjectId());
        }
    }

    @Override
    public void deleteAllComponents(@Nonnull Long projectId) {
        this.delegateStore.deleteAllComponents(projectId);
        this.componentIdToComponentMap.removeAll();
        this.projectIdToComponentsMap.remove((Object)projectId);
    }

    @Override
    public Collection findComponentsBylead(String userKey) {
        ArrayList<MutableProjectComponent> leadComponents = new ArrayList<MutableProjectComponent>();
        Collection<ProjectComponent> components = this.findAll();
        for (ProjectComponent component : components) {
            MutableProjectComponent projectComponent = (MutableProjectComponent)component;
            if (projectComponent == null || !TextUtils.stringSet((String)projectComponent.getLead()) || !projectComponent.getLead().equals(userKey)) continue;
            leadComponents.add(projectComponent);
        }
        return leadComponents;
    }

    @Override
    public Collection<ProjectComponent> findAll() {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>();
        List allProjects = projectManager.getProjectObjects();
        for (Project project : allProjects) {
            components.addAll((Collection)this.projectIdToComponentsMap.get((Object)project.getId()));
        }
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private MutableProjectComponent insert(MutableProjectComponent component) {
        this.updateLock.lock();
        try {
            MutableProjectComponent mutableProjectComponent;
            String name = component.getName();
            if (this.containsName(name, component.getProjectId())) {
                throw this.createIllegalArgumentExceptionForName(name);
            }
            try {
                mutableProjectComponent = component = this.delegateStore.store(component);
            }
            catch (EntityNotFoundException e) {
                MutableProjectComponent mutableProjectComponent2 = null;
                this.componentIdToComponentMap.remove((Object)component.getId());
                this.projectIdToComponentsMap.remove((Object)component.getProjectId());
                this.updateLock.unlock();
                return mutableProjectComponent2;
                {
                    catch (Throwable throwable) {
                        this.componentIdToComponentMap.remove((Object)component.getId());
                        this.projectIdToComponentsMap.remove((Object)component.getProjectId());
                        throw throwable;
                    }
                }
            }
            this.componentIdToComponentMap.remove((Object)component.getId());
            this.projectIdToComponentsMap.remove((Object)component.getProjectId());
            return mutableProjectComponent;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutableProjectComponent update(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        this.updateLock.lock();
        try {
            MutableProjectComponent old = this.find(component.getId());
            if (!old.equalsName(component) && this.containsName(component.getName(), component.getProjectId())) {
                throw new IllegalArgumentException("New component name '" + component.getName() + "' is not unique!");
            }
            this.delegateStore.store(component);
            this.updateCache((ProjectComponent)component);
            MutableProjectComponent mutableProjectComponent = component;
            return mutableProjectComponent;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private void updateCache(ProjectComponent component) {
        Long id = component.getId();
        Long projectId = component.getProjectId();
        this.componentIdToComponentMap.remove((Object)id);
        this.projectIdToComponentsMap.remove((Object)projectId);
    }

    private IllegalArgumentException createIllegalArgumentExceptionForName(String name) {
        return new IllegalArgumentException("Component name = '" + name + "' is not unique");
    }

    private Collection<ProjectComponent> sortByComponentNames(Collection<MutableProjectComponent> components) {
        ArrayList<MutableProjectComponent> componentList = new ArrayList<MutableProjectComponent>(components);
        Collections.sort(componentList, ProjectComponentComparator.INSTANCE);
        return componentList;
    }

    @Nonnull
    private Collection<ProjectComponent> loadComponentsByProjectId(Long projectId) {
        return this.sortByComponentNames(this.delegateStore.findAllForProject(projectId));
    }

    @Nonnull
    private Optional<ProjectComponent> loadComponentById(Long projectId) {
        try {
            return Optional.of(this.delegateStore.find(projectId));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
    }
}

