/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.annotations.Internal;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.group.GroupsToApplicationsSeatingHelper;
import com.atlassian.jira.bc.user.EffectiveApplication;
import com.atlassian.jira.bc.user.GroupView;
import com.atlassian.jira.bc.user.UserApplicationHelper;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.auth.AuthorisationManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.Streams;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.component.admin.group.GroupLabelView;
import com.atlassian.jira.web.component.admin.group.GroupLabelsService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;

@Internal
public class CreateUserApplicationHelper
implements UserApplicationHelper {
    private final Map<UserApplicationHelper.ValidationScope, ValidationFunction> validationFunctions;
    private final ApplicationRoleManager applicationRoleManager;
    private final I18nHelper i18nHelper;
    private final BaseUrl baseUrl;
    private final GlobalPermissionManager globalPermissionManager;
    private final LicenseCountService licenseCountService;
    private final FeatureManager featureManager;
    private final JiraLicenseManager jiraLicenseManager;
    private final GroupsToApplicationsSeatingHelper groupsToApplicationsSeatingHelper;
    private final UserManager userManager;
    private final CrowdService crowdService;
    private final GroupLabelsService groupLabels;
    private final AuthorisationManager authorisationManager;
    @VisibleForTesting
    static final String LINK_START = "<a href=\"%s\">";
    @VisibleForTesting
    static final String LINK_END = "</a>";

    public CreateUserApplicationHelper(ApplicationRoleManager applicationRoleManager, I18nHelper i18nHelper, BaseUrl baseUrl, GlobalPermissionManager globalPermissionManager, LicenseCountService licenseCountService, FeatureManager featureManager, JiraLicenseManager jiraLicenseManager, GroupsToApplicationsSeatingHelper groupsToApplicationsSeatingHelper, UserManager userManager, CrowdService crowdService, GroupLabelsService groupLabels, AuthorisationManager authorisationManager) {
        this.applicationRoleManager = applicationRoleManager;
        this.i18nHelper = i18nHelper;
        this.baseUrl = baseUrl;
        this.groupsToApplicationsSeatingHelper = groupsToApplicationsSeatingHelper;
        this.userManager = userManager;
        this.globalPermissionManager = globalPermissionManager;
        this.licenseCountService = licenseCountService;
        this.featureManager = featureManager;
        this.jiraLicenseManager = jiraLicenseManager;
        this.crowdService = crowdService;
        this.groupLabels = groupLabels;
        this.authorisationManager = authorisationManager;
        this.validationFunctions = ImmutableMap.of((Object)((Object)UserApplicationHelper.ValidationScope.ACCESS), this::validateRoleAccess, (Object)((Object)UserApplicationHelper.ValidationScope.SEATS), this::validateRoleSeats, (Object)((Object)UserApplicationHelper.ValidationScope.EXPIRE), this::validateLicenseExpire);
    }

    @Override
    @Nonnull
    public List<UserApplicationHelper.ApplicationSelection> getApplicationsForSelection(@Nonnull Set<ApplicationKey> selectedApplicationKeys, @Nonnull Optional<Long> directoryId) {
        Assertions.notNull((String)"selectedApplicationKeys", selectedApplicationKeys);
        Set<Group> selectedGroups = this.getSelectedGroups(selectedApplicationKeys);
        return this.getApplicationsFor(role -> selectedApplicationKeys.contains(role.getKey()), role -> {
            Set groups = role.getGroups();
            return !groups.isEmpty() && !CollectionUtils.intersection((Collection)selectedGroups, (Collection)groups).isEmpty();
        }, directoryId);
    }

    @Override
    @Nonnull
    public List<UserApplicationHelper.ApplicationSelection> getApplicationsForUser(@Nonnull ApplicationUser user) {
        Assertions.notNull((String)"user", (Object)user);
        Optional<Long> directoryId = Optional.of(user.getDirectoryId());
        Predicate<Group> groupPredicate = group -> this.crowdService.isUserMemberOfGroup(user.getDirectoryUser(), group);
        return this.getApplicationsFor(role -> {
            Set defaultGroups = role.getDefaultGroups();
            if (!defaultGroups.isEmpty()) {
                return defaultGroups.stream().allMatch(groupPredicate);
            }
            Set groups = role.getGroups();
            return !groups.isEmpty() && groups.stream().allMatch(groupPredicate);
        }, role -> role.getGroups().stream().anyMatch(groupPredicate), targetRole -> this.applicationRoleManager.getRoles().stream().filter(role -> !role.getKey().equals((Object)targetRole.getKey())).map(ApplicationRole::getGroups).flatMap(Collection::stream).filter(group -> targetRole.getGroups().contains(group)).anyMatch(groupPredicate), directoryId);
    }

    private List<UserApplicationHelper.ApplicationSelection> getApplicationsFor(Predicate<ApplicationRole> isSelected, Predicate<ApplicationRole> isIndeterminate, Optional<Long> directoryId) {
        return this.getApplicationsFor(isSelected, isIndeterminate, isIndeterminate, directoryId);
    }

    private List<UserApplicationHelper.ApplicationSelection> getApplicationsFor(Predicate<ApplicationRole> isSelected, Predicate<ApplicationRole> isIndeterminate, Predicate<ApplicationRole> isEffective, Optional<Long> directoryId) {
        HashSet applicationSelection = Sets.newHashSet();
        Set roles = this.applicationRoleManager.getRoles();
        Option coreRole = this.applicationRoleManager.getRole(ApplicationKeys.CORE);
        for (ApplicationRole role : roles) {
            String displayName = coreRole.isDefined() && !role.getKey().equals((Object)ApplicationKeys.CORE) ? this.i18nHelper.getText("admin.adduser.application.selection.name.includes.core", role.getName(), ((ApplicationRole)coreRole.get()).getName()) : this.i18nHelper.getText("admin.adduser.application.selection.name.without.core", role.getName());
            Optional<ValidationResult> errorMessage = this.validateRole(role, EnumSet.allOf(UserApplicationHelper.ValidationScope.class), ValidationParams.withDirectory(directoryId));
            boolean selected = isSelected.test(role);
            boolean selectable = !errorMessage.isPresent();
            String message = errorMessage.isPresent() ? errorMessage.get().getMessage() : null;
            String markup = errorMessage.isPresent() ? errorMessage.get().getMessageMarkup() : null;
            boolean indeterminate = !selected && isIndeterminate.test(role);
            boolean effective = indeterminate && isEffective.test(role);
            boolean deselectable = (selected || indeterminate) && errorMessage.isPresent();
            Set effectiveApplicationKeys = (Set)this.groupsToApplicationsSeatingHelper.findEffectiveApplications(directoryId, (Set<ApplicationRole>)ImmutableSet.of((Object)role)).stream().map(effectiveRole -> new EffectiveApplication(effectiveRole.getKey(), effectiveRole.getName())).collect(CollectorsUtil.toImmutableSet());
            applicationSelection.add(new UserApplicationHelper.ApplicationSelection(role.getKey(), role.getName(), displayName, message, markup, selectable, selected, role.isDefined(), indeterminate, effective, deselectable, effectiveApplicationKeys));
        }
        return Ordering.natural().sortedCopy((Iterable)applicationSelection);
    }

    @Override
    @Nonnull
    public List<GroupView> getUserGroups(@Nonnull ApplicationUser applicationUser) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(applicationUser.getName()).returningAtMost(-1);
        return (List)Streams.stream(this.crowdService.search((Query)membershipQuery)).map(group -> new GroupView(group.getName(), this.getGroupLabels((Group)group, applicationUser))).collect(CollectorsUtil.toImmutableList());
    }

    private List<GroupLabelView> getGroupLabels(Group group, ApplicationUser user) {
        return this.groupLabels.getGroupLabels(group, Optional.of(user.getDirectoryId()));
    }

    private Set<Group> getSelectedGroups(@Nonnull Set<ApplicationKey> selectedApplicationKeys) {
        return (Set)selectedApplicationKeys.stream().map(arg_0 -> ((ApplicationRoleManager)this.applicationRoleManager).getRole(arg_0)).filter(Maybe::isDefined).map(Maybe::get).map(ApplicationRole::getDefaultGroups).flatMap(Collection::stream).collect(CollectorsUtil.toImmutableSet());
    }

    @Override
    @Nonnull
    public Collection<String> validateDefaultApplications(EnumSet<UserApplicationHelper.ValidationScope> validationScope, Optional<Long> directoryId) {
        return this.validateApplicationKeys(directoryId, (Set<ApplicationKey>)this.applicationRoleManager.getDefaultApplicationKeys(), validationScope);
    }

    @Override
    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull Optional<Long> directoryId, @Nonnull Set<ApplicationKey> applicationKeys) {
        return this.validateApplicationKeys(directoryId, applicationKeys, EnumSet.allOf(UserApplicationHelper.ValidationScope.class));
    }

    @Override
    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull ApplicationUser user, @Nonnull Set<ApplicationKey> applicationKeys) {
        return this.validateApplicationKeys(ValidationParams.withUser(user), applicationKeys, EnumSet.allOf(UserApplicationHelper.ValidationScope.class));
    }

    @Override
    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull Optional<Long> directoryId, @Nonnull Set<ApplicationKey> applicationKeys, @Nonnull EnumSet<UserApplicationHelper.ValidationScope> validationScope) {
        return this.validateApplicationKeys(ValidationParams.withDirectory(directoryId), applicationKeys, validationScope);
    }

    @Nonnull
    private Collection<String> validateApplicationKeys(@Nonnull ValidationParams validationParams, @Nonnull Set<ApplicationKey> applicationKeys, @Nonnull EnumSet<UserApplicationHelper.ValidationScope> validationScope) {
        ArrayList<String> errors = new ArrayList<String>();
        Assertions.containsNoNulls((String)"applicationKeys", applicationKeys);
        HashSet applicationRoles = Sets.newHashSet();
        for (ApplicationKey applicationKey : applicationKeys) {
            Option role = this.applicationRoleManager.getRole(applicationKey);
            if (role.isEmpty()) {
                errors.add(this.i18nHelper.getText("admin.errors.user.add.user.application.not.licensed", applicationKey.value()));
                continue;
            }
            applicationRoles.add(role.get());
        }
        Long directoryOrDefault = validationParams.getDirectoryId().orElseGet(() -> this.userManager.getDefaultCreateDirectory().map(Directory::getId).orElse(null));
        if (directoryOrDefault == null) {
            errors.add(this.i18nHelper.getText("admin.errors.no.writable.directory"));
            return ImmutableList.copyOf(errors);
        }
        Set<ApplicationRole> applicationsEffectivelyGranted = this.groupsToApplicationsSeatingHelper.findEffectiveApplications(Optional.of(directoryOrDefault), applicationRoles);
        if (validationScope.contains((Object)UserApplicationHelper.ValidationScope.ACCESS) && !applicationsEffectivelyGranted.containsAll(applicationRoles)) {
            errors.add(this.i18nHelper.getText("admin.errors.user.add.user.application.access.effectively.not.granted"));
            return ImmutableList.copyOf(errors);
        }
        for (ApplicationRole applicationRole : applicationsEffectivelyGranted) {
            Optional<ValidationResult> message = this.validateRole(applicationRole, validationScope, validationParams);
            if (!message.isPresent()) continue;
            errors.add(message.get().getMessage());
        }
        return ImmutableList.copyOf(errors);
    }

    @Override
    public boolean canUserLogin(@Nullable ApplicationUser applicationUser) {
        return applicationUser != null && this.authorisationManager.hasUserAccessToJIRA(applicationUser);
    }

    public Set<Group> getDefaultGroupsForNewUser(Set<ApplicationKey> applicationKeys) {
        return (Set)applicationKeys.stream().filter(appKey -> this.applicationRoleManager.hasSeatsAvailable(appKey, 1)).flatMap(appKey -> this.applicationRoleManager.getDefaultGroups(appKey).stream()).collect(CollectorsUtil.toImmutableSet());
    }

    @Nonnull
    private Optional<ValidationResult> validateRole(@Nonnull ApplicationRole role, @Nonnull EnumSet<UserApplicationHelper.ValidationScope> validationScope, ValidationParams params) {
        return Stream.of(UserApplicationHelper.ValidationScope.EXPIRE, UserApplicationHelper.ValidationScope.SEATS, UserApplicationHelper.ValidationScope.ACCESS).filter(validationScope::contains).map(this.validationFunctions::get).map(validation -> validation.validate(role, params)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    @VisibleForTesting
    Optional<ValidationResult> validateRoleSeats(@Nonnull ApplicationRole role, ValidationParams params) {
        if (params.hasUser() && this.applicationRoleManager.getRolesForUser(params.getUser().get()).contains(role)) {
            return Optional.empty();
        }
        if (!this.applicationRoleManager.hasSeatsAvailable(role.getKey(), 1)) {
            String message = this.i18nHelper.getText("admin.errors.user.add.user.application.license.limit.reached", (Object)role.getName(), (Object)"", (Object)"", (Object)"", (Object)"");
            String userBrowserStart = String.format(LINK_START, this.getUserBrowserUrl());
            String versionsAndLicensesStart = String.format(LINK_START, this.getVersionsAndLicensesUrl());
            String markup = this.i18nHelper.getText("admin.errors.user.add.user.application.license.limit.reached", (Object)role.getName(), (Object)userBrowserStart, (Object)LINK_END, (Object)versionsAndLicensesStart, (Object)LINK_END);
            return Optional.of(new ValidationResult(message, markup));
        }
        return Optional.empty();
    }

    private Optional<ValidationResult> validateRoleAccess(@Nonnull ApplicationRole role, ValidationParams params) {
        Directory directory;
        if (role.getDefaultGroups().isEmpty()) {
            String message = this.i18nHelper.getText("admin.errors.user.add.user.application.no.default.group", role.getName(), "", "");
            String start = String.format(LINK_START, this.getApplicationAssessUrl());
            String markup = this.i18nHelper.getText("admin.errors.user.add.user.application.no.default.group", role.getName(), start, LINK_END);
            return Optional.of(new ValidationResult(message, markup));
        }
        if (params.getDirectoryId().isPresent() && !(directory = this.userManager.getDirectory(params.getDirectoryId().get())).getAllowedOperations().contains(OperationType.CREATE_GROUP)) {
            String message = this.i18nHelper.getText("admin.errors.directory.fully.read.only", directory.getName());
            return Optional.of(new ValidationResult(message, message));
        }
        return Optional.empty();
    }

    private Optional<ValidationResult> validateLicenseExpire(@Nonnull ApplicationRole role, ValidationParams params) {
        if (!role.isDefined()) {
            return Optional.empty();
        }
        Option license = this.jiraLicenseManager.getLicense(role.getKey());
        if (license.isEmpty() || ((LicenseDetails)license.get()).isExpired()) {
            String message = this.i18nHelper.getText("admin.errors.user.add.user.application.license.expired", role.getName(), "", "");
            String start = String.format(LINK_START, this.getVersionsAndLicensesUrl());
            String markup = this.i18nHelper.getText("admin.errors.user.add.user.application.license.expired", role.getName(), start, LINK_END);
            return Optional.of(new ValidationResult(message, markup));
        }
        return Optional.empty();
    }

    private String getApplicationAssessUrl() {
        return this.baseUrl.getBaseUrl() + "/secure/admin/ApplicationAccess.jspa";
    }

    private String getUserBrowserUrl() {
        return this.baseUrl.getBaseUrl() + "/secure/admin/user/UserBrowser.jspa";
    }

    private String getVersionsAndLicensesUrl() {
        return this.baseUrl.getBaseUrl() + "/plugins/servlet/applications/versions-licenses";
    }

    @VisibleForTesting
    static class ValidationParams {
        private final Optional<Long> directoryId;
        private final Optional<ApplicationUser> user;

        private ValidationParams(Optional<ApplicationUser> user, Optional<Long> directoryId) {
            this.user = user;
            this.directoryId = directoryId;
        }

        public static ValidationParams withUser(ApplicationUser user) {
            return new ValidationParams(Optional.ofNullable(user), Optional.empty());
        }

        public static ValidationParams withDirectory(Optional<Long> directoryId) {
            return new ValidationParams(Optional.empty(), directoryId);
        }

        public static ValidationParams empty() {
            return new ValidationParams(Optional.empty(), Optional.empty());
        }

        public Optional<Long> getDirectoryId() {
            return Stream.of(this.user.map(ApplicationUser::getDirectoryId), this.directoryId).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        }

        public Optional<ApplicationUser> getUser() {
            return this.user;
        }

        public boolean hasUser() {
            return this.user.isPresent();
        }
    }

    @VisibleForTesting
    static class ValidationResult {
        private final String message;
        private final String messageMarkup;

        ValidationResult(String message, String messageMarkup) {
            this.message = message;
            this.messageMarkup = messageMarkup;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageMarkup() {
            return this.messageMarkup;
        }
    }

    public static interface ValidationFunction {
        public Optional<ValidationResult> validate(ApplicationRole var1, ValidationParams var2);
    }
}

