/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.request;

import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.cache.request.RequestCache;
import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.cache.request.context.RequestCacheContext;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class RequestCacheImpl<K, V>
implements RequestCache<K, V> {
    private final CacheLoader<K, V> cacheLoader;
    private final String name;

    RequestCacheImpl(@Nonnull String name, @Nonnull CacheLoader<K, V> cacheLoader) {
        this.name = (String)Assertions.notNull((String)"name", (Object)name);
        this.cacheLoader = (CacheLoader)Assertions.notNull((String)"cacheLoader", cacheLoader);
    }

    @Nonnull
    public V get(K key) {
        Assertions.notNull((String)"key", key);
        RequestCacheContext cacheContext = RequestCacheController.getContext();
        if (cacheContext == null) {
            return (V)this.getNotNull("cacheLoader", key, this.cacheLoader.load(key));
        }
        Map<Object, Object> localMap = cacheContext.getLocalMap(this);
        Object cachedValue = localMap.get(key);
        if (cachedValue != null) {
            return (V)cachedValue;
        }
        Object loadedValue = this.getNotNull("cacheLoader", key, this.cacheLoader.load(key));
        localMap.put(key, loadedValue);
        cacheContext.markValueLoading();
        return (V)loadedValue;
    }

    @Nullable
    public V getIfPresent(K key) {
        Assertions.notNull((String)"key", key);
        RequestCacheContext cacheContext = RequestCacheController.getContext();
        if (cacheContext == null) {
            return null;
        }
        Map<Object, Object> localMap = cacheContext.getLocalMapIfExists(this);
        return (V)(localMap != null ? localMap.get(key) : null);
    }

    @Nonnull
    public V get(K key, Supplier<V> supplier) {
        Assertions.notNull((String)"key", key);
        RequestCacheContext cacheContext = RequestCacheController.getContext();
        if (cacheContext == null) {
            return (V)this.getNotNull("supplier", key, supplier.get());
        }
        Map<Object, Object> localMap = cacheContext.getLocalMap(this);
        Object cachedValue = localMap.get(key);
        if (cachedValue != null) {
            return (V)cachedValue;
        }
        Object loadedValue = this.getNotNull("supplier", key, supplier.get());
        localMap.put(key, loadedValue);
        cacheContext.markValueLoading();
        return (V)loadedValue;
    }

    public void remove(K key) {
        RequestCacheContext cacheContext = RequestCacheController.getContext();
        if (cacheContext == null) {
            return;
        }
        Map<Object, Object> localMap = cacheContext.getLocalMapIfExists(this);
        if (localMap != null) {
            localMap.remove(key);
        }
    }

    public void removeAll() {
        RequestCacheContext cacheContext = RequestCacheController.getContext();
        if (cacheContext != null) {
            cacheContext.clearLocalMap(this);
        }
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ']';
    }

    private V getNotNull(String description, K key, @Nullable V loadedValue) {
        if (loadedValue == null) {
            throw new IllegalArgumentException(description + " returned null for key '" + key + '\'');
        }
        return loadedValue;
    }
}

