/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.serialcheck;

import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.jira.cache.serialcheck.SerializationChecker;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SerializationCheckedCachedReference<V>
implements CachedReference<V> {
    private final SerializationChecker checker;
    private final String name;
    private final CachedReference<V> delegate;
    private volatile boolean valueChecked;

    public SerializationCheckedCachedReference(SerializationChecker checker, String name, CachedReference<V> delegate) {
        this.checker = checker;
        this.name = name;
        this.delegate = delegate;
    }

    @Nonnull
    public V get() {
        Object result = this.delegate.get();
        if (!this.valueChecked) {
            this.valueChecked = true;
            this.checker.checkValue(this, this.name, result);
        }
        return (V)result;
    }

    public void reset() {
        this.valueChecked = false;
        this.delegate.reset();
    }

    public void addListener(CachedReferenceListener<V> listener, boolean includeValues) {
        this.delegate.addListener(listener, includeValues);
    }

    public void removeListener(CachedReferenceListener<V> listener) {
        this.delegate.removeListener(listener);
    }
}

