/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartbeatService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class ClusterTaskCleanupService
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(ClusterTaskCleanupService.class);
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)ClusterTaskCleanupService.class.getName());
    static final JobId JOB_ID = JobId.of((String)ClusterTaskCleanupService.class.getName());
    static final String RUN_INTERVAL_PROPERTY_KEY = "cluster.task.cleanup.run.interval";
    static final String OFFLINE_NODE_THRESHOLD_PROPERTY_KEY = "cluster.task.cleanup.offline.node.threshold";
    static final int MINIMUM_OFFLINE_NODE_THRESHOLD = 10;
    private final SchedulerService schedulerService;
    private final ClusterManager clusterManager;
    private final ClusterNodeHeartbeatService heartbeatService;
    private final TaskManager taskManager;
    private final FeatureManager featureManager;
    private final ApplicationProperties applicationProperties;

    public ClusterTaskCleanupService(SchedulerService schedulerService, ClusterManager clusterManager, ClusterNodeHeartbeatService heartbeatService, TaskManager taskManager, FeatureManager featureManager, ApplicationProperties applicationProperties) {
        this.schedulerService = Objects.requireNonNull(schedulerService);
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.heartbeatService = Objects.requireNonNull(heartbeatService);
        this.taskManager = Objects.requireNonNull(taskManager);
        this.featureManager = Objects.requireNonNull(featureManager);
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
    }

    public void start() {
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.CLEANUP_CLUSTER_TASKS)) {
            log.debug("Registering ClusterTaskCleanupService");
            this.registerJob();
        } else {
            log.debug("ClusterTaskCleanupService is disabled");
        }
    }

    public void stop() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private void registerJob() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        Date fiveMinutesFromNow = new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)TimeUnit.SECONDS.toMillis(this.getRunIntervalInSeconds()), (Date)fiveMinutesFromNow));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error(String.format("Failed to schedule cluster task cleanup job %s", JOB_ID), (Throwable)e);
        }
    }

    @VisibleForTesting
    long getRunIntervalInSeconds() {
        String propertyValue = this.applicationProperties.getDefaultBackedString(RUN_INTERVAL_PROPERTY_KEY);
        try {
            return Long.parseLong(propertyValue);
        }
        catch (NumberFormatException e) {
            log.error("Unable to parse the '{}' property value '{}' as a number. Jira will use the default value.", (Object)RUN_INTERVAL_PROPERTY_KEY, (Object)propertyValue);
            return Long.parseLong(this.applicationProperties.getDefaultString(RUN_INTERVAL_PROPERTY_KEY));
        }
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (!this.clusterManager.isActive()) {
            return JobRunnerResponse.failed((String)"Current node is not active");
        }
        this.getTasksToRemove().forEach(this::removeTask);
        return JobRunnerResponse.success();
    }

    private List<TaskDescriptor<?>> getTasksToRemove() {
        Map<String, List<TaskDescriptor>> tasksByNode = this.taskManager.getLiveTasks().stream().collect(Collectors.groupingBy(TaskDescriptor::getNodeId));
        Collection<String> liveNodeIds = this.heartbeatService.findLiveNodes(TimeUnit.MINUTES.toMillis(this.getOfflineNodeThresholdInMinutes()));
        return tasksByNode.entrySet().stream().filter(entry -> !liveNodeIds.contains(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).filter(task -> !task.isSelfRecovering()).collect(Collectors.toList());
    }

    @VisibleForTesting
    int getOfflineNodeThresholdInMinutes() {
        String propertyValue = this.applicationProperties.getDefaultBackedString(OFFLINE_NODE_THRESHOLD_PROPERTY_KEY);
        try {
            int offlineNodeThreshold = Integer.parseInt(propertyValue);
            return Math.max(offlineNodeThreshold, 10);
        }
        catch (NumberFormatException e) {
            log.error("Unable to parse the '{}' property value '{}' as a number. Jira will use the default value.", (Object)OFFLINE_NODE_THRESHOLD_PROPERTY_KEY, (Object)propertyValue);
            return Integer.parseInt(this.applicationProperties.getDefaultString(OFFLINE_NODE_THRESHOLD_PROPERTY_KEY));
        }
    }

    private void removeTask(TaskDescriptor<?> task) {
        log.error("Removing stale '{}' task '{}' started on node '{}'.", new Object[]{task.getDescription(), task.getTaskId(), task.getNodeId()});
        this.taskManager.removeTask(task.getTaskId());
    }
}

