/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterNodes;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.ClusterStateException;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.cache.NodeCutOffManager;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartbeatService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.index.ha.IndexesRestoredEvent;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.license.ClusterLicenseCheck;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterManager
implements ClusterManager,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterManager.class);
    private final ClusterNodes clusterNodes;
    private final EventPublisher eventPublisher;
    private final ClusterLicenseCheck licenseCheck;
    private final MessageHandlerService messageHandlerService;
    private final NodeCutOffManager nodeCutOffManager;
    private volatile Collection<Node> liveNodes;
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<ClusterNodeHeartbeatService> heartbeatServiceRef = ComponentAccessor.getComponentReference(ClusterNodeHeartbeatService.class);
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<NodeReindexService> nodeReindexServiceRef = ComponentAccessor.getComponentReference(NodeReindexService.class);

    public DefaultClusterManager(ClusterNodes clusterNodes, EventPublisher eventPublisher, ClusterLicenseCheck licenseCheck, MessageHandlerService messageHandlerService, NodeCutOffManager nodeCutOffManager) {
        this.clusterNodes = clusterNodes;
        this.eventPublisher = eventPublisher;
        this.licenseCheck = licenseCheck;
        this.messageHandlerService = messageHandlerService;
        this.nodeCutOffManager = nodeCutOffManager;
    }

    public void start() {
        this.eventPublisher.register((Object)this);
    }

    @Nullable
    public String getNodeId() {
        return this.clusterNodes.current().getNodeId();
    }

    public boolean isClustered() {
        return this.clusterNodes.current().isClustered();
    }

    @Override
    public Set<Node> getAllNodes() {
        return this.isClustered() ? this.clusterNodes.all() : ImmutableSet.of();
    }

    @Override
    public boolean isActive() {
        return this.clusterNodes.current().getState().equals((Object)Node.NodeState.ACTIVE);
    }

    @Override
    public void checkIndex() {
        if (((NodeReindexService)this.nodeReindexServiceRef.get()).canIndexBeRebuilt()) {
            log.info("Current node index can be rebuilt from index operations table. Not requesting index from other node.");
        } else {
            String currentNodeId = this.clusterNodes.current().getNodeId();
            Set allOtherNodeIds = this.clusterNodes.all().stream().filter(Node::isClustered).map(Node::getNodeId).filter(Objects::nonNull).filter(nodeId -> !nodeId.equals(currentNodeId)).collect(Collectors.toSet());
            log.info("Current node: {} index can't be rebuilt. Requesting an index from any other node. Current list of other nodes: {}", (Object)currentNodeId, allOtherNodeIds);
            this.requestCurrentIndexFromNode("ANY");
        }
    }

    @Override
    public void requestCurrentIndexFromNode(String destinationNode) {
        ((NodeReindexService)this.nodeReindexServiceRef.get()).pause();
        ((NodeReindexService)this.nodeReindexServiceRef.get()).resetIndexCount();
        log.info("Sending message: \"{}\" - request to create index snapshot from node: {} on current node: {}", new Object[]{"Backup Index", destinationNode, this.getNodeId()});
        this.messageHandlerService.sendMessage(destinationNode, new Message("Backup Index", null));
    }

    @Override
    public Collection<Node> findLiveNodes() {
        if (this.liveNodes == null) {
            this.refreshLiveNodes();
        }
        return this.liveNodes;
    }

    @Override
    public void refreshLiveNodes() {
        final Collection<String> heartbeatLiveNodesIds = ((ClusterNodeHeartbeatService)this.heartbeatServiceRef.get()).findLiveNodes();
        Collection filter = CollectionUtil.filter(this.getAllNodes(), (Predicate)new Predicate<Node>(){

            public boolean evaluate(Node node) {
                return node != null && node.getState() == Node.NodeState.ACTIVE && heartbeatLiveNodesIds.contains(node.getNodeId());
            }
        });
        this.liveNodes = ImmutableSet.copyOf((Collection)filter);
        this.nodeCutOffManager.removeStaleCutOffExecutors(this.liveNodes);
    }

    @EventListener
    public void releaseNodeReindexService(IndexesRestoredEvent ev) {
        ((NodeReindexService)this.nodeReindexServiceRef.get()).start();
        ((NodeReindexService)this.nodeReindexServiceRef.get()).replayLocalOperations();
    }

    @Override
    public boolean isClusterLicensed() {
        return this.licenseCheck.evaluate().isPass();
    }

    @Override
    public void removeIfOffline(@NotNull String nodeId) throws ClusterStateException {
        this.clusterNodes.removeIfOffline(nodeId);
    }

    @Override
    public void moveToOffline(@NotNull String nodeId) throws ClusterStateException {
        this.refreshLiveNodes();
        Node node = this.clusterNodes.node(nodeId);
        if (node != null && (this.scanIsNodeAlive(node) || node.getState() != Node.NodeState.ACTIVE)) {
            throw new ClusterStateException("You can only change state of non alive and active node");
        }
        this.clusterNodes.moveToOffline(nodeId);
    }

    @Override
    public boolean isNodeAlive(@NotNull String nodeId) {
        this.refreshLiveNodes();
        Node node = this.clusterNodes.node(nodeId);
        return node != null && this.scanIsNodeAlive(node);
    }

    private boolean scanIsNodeAlive(@NotNull Node node) {
        return this.liveNodes.stream().anyMatch(n -> n.getNodeId().equals(node.getNodeId()));
    }

    @Override
    public boolean isNodePresent(@NotNull String nodeId) {
        Node node = this.clusterNodes.node(nodeId);
        return node != null;
    }

    @Override
    public boolean isNodeOffline(@NotNull String nodeId) {
        Node node = this.clusterNodes.node(nodeId);
        return node != null && node.getState() == Node.NodeState.OFFLINE;
    }
}

