/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.ClusterMessage;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizClusterMessageStore {
    @VisibleForTesting
    protected static final String DESTINATION_NODE = "destinationNode";
    @VisibleForTesting
    protected static final String ENTITY = "ClusterMessage";
    @VisibleForTesting
    protected static final String ID = "id";
    @VisibleForTesting
    protected static final String MESSAGE = "message";
    @VisibleForTesting
    protected static final String SOURCE_NODE = "sourceNode";
    @VisibleForTesting
    protected static final String CLAIMED_BY_NODE = "claimedByNode";
    @VisibleForTesting
    protected static final String MESSAGE_TIME = "messageTime";
    private final OfBizDelegator ofBizDelegator;

    public OfBizClusterMessageStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public GenericValue storeMessage(@Nonnull ClusterMessage message) {
        return this.storeFieldMap(this.getFields(message));
    }

    public ClusterMessage createMessage(@Nonnull String sourceNode, @Nonnull String destinationNode, @Nonnull String message) {
        ImmutableMap fields = ImmutableMap.of((Object)SOURCE_NODE, (Object)sourceNode, (Object)DESTINATION_NODE, (Object)destinationNode, (Object)MESSAGE, (Object)message, (Object)MESSAGE_TIME, (Object)new Timestamp(new Date().getTime()));
        GenericValue gv = this.storeFieldMap((Map<String, Object>)fields);
        return this.fromGv(gv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClusterMessage> getMessages(Node sourceNode, Node destinationNode, Long afterMessageId) {
        if (!destinationNode.isClustered()) {
            return ImmutableList.of();
        }
        String destinationNodeId = destinationNode.getNodeId();
        String sourceNodeId = sourceNode.getNodeId();
        EntityExpr findByNodeid = new EntityExpr(DESTINATION_NODE, EntityOperator.EQUALS, (Object)destinationNodeId);
        EntityExpr findByAllNodes = new EntityExpr(DESTINATION_NODE, EntityOperator.EQUALS, (Object)"ALL");
        EntityExpr findByAnyNode = new EntityExpr(DESTINATION_NODE, EntityOperator.EQUALS, (Object)"ANY");
        EntityExpr findBySourceNodeId = new EntityExpr(SOURCE_NODE, EntityOperator.EQUALS, (Object)sourceNodeId);
        EntityConditionList findByNodes = new EntityConditionList((List)Lists.newArrayList((Object[])new EntityCondition[]{findByNodeid, findByAnyNode, findByAllNodes}), EntityOperator.OR);
        ArrayList conditionList = Lists.newArrayList((Object[])new EntityCondition[]{findByNodes, findBySourceNodeId});
        if (afterMessageId != null) {
            conditionList.add(new EntityExpr(ID, EntityOperator.GREATER_THAN, (Object)afterMessageId));
        }
        EntityConditionList completeCondition = new EntityConditionList((List)conditionList, EntityOperator.AND);
        try (OfBizListIterator it = this.ofBizDelegator.findListIteratorByCondition(ENTITY, (EntityCondition)completeCondition, null, null, (List)ImmutableList.of((Object)ID), null);){
            ArrayList<ClusterMessage> messages = new ArrayList<ClusterMessage>();
            for (GenericValue genericValue : it) {
                int updated;
                ClusterMessage message = this.fromGv(genericValue);
                if ("ANY".equals(message.getDestinationNode()) && (updated = this.ofBizDelegator.bulkUpdateByAnd(ENTITY, (Map)FieldMap.build((String)CLAIMED_BY_NODE, (Object)destinationNodeId), (Map)FieldMap.build((String)ID, (Object)message.getId(), (String)CLAIMED_BY_NODE, null))) == 0) continue;
                messages.add(message);
            }
            ArrayList<ClusterMessage> arrayList = messages;
            return arrayList;
        }
    }

    public int deleteMessage(ClusterMessage clusterMessage) {
        return this.ofBizDelegator.removeById(ENTITY, clusterMessage.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLatestMessageByNodeId(String nodeId) {
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition(ENTITY, (EntityCondition)new EntityExpr(SOURCE_NODE, EntityOperator.EQUALS, (Object)nodeId), null, (Collection)ImmutableList.of((Object)ID), (List)ImmutableList.of((Object)"id DESC"), EntityFindOptions.findOptions().maxResults(1));){
            Iterator iterator2 = iterator.iterator();
            if (iterator2.hasNext()) {
                GenericValue gV = (GenericValue)iterator2.next();
                Long l = gV.getLong(ID);
                return l;
            }
            iterator2 = null;
            return iterator2;
        }
    }

    private ClusterMessage fromGv(@Nonnull GenericValue gv) {
        Message message = Message.fromString(gv.getString(MESSAGE));
        return new ClusterMessage(gv.getLong(ID), gv.getString(SOURCE_NODE), gv.getString(DESTINATION_NODE), gv.getString(CLAIMED_BY_NODE), message, gv.getTimestamp(MESSAGE_TIME));
    }

    private GenericValue storeFieldMap(@Nonnull Map<String, Object> fields) {
        return this.ofBizDelegator.createValue(ENTITY, fields);
    }

    private Map<String, Object> getFields(ClusterMessage message) {
        return new FieldMap(ID, (Object)message.getId()).add(SOURCE_NODE, (Object)message.getSourceNode()).add(DESTINATION_NODE, (Object)message.getDestinationNode()).add(CLAIMED_BY_NODE, (Object)message.getClaimedByNode()).add(MESSAGE, (Object)message.getMessage()).add(MESSAGE_TIME, (Object)message.getTimestamp());
    }

    public int deleteMessagesBefore(Date before) {
        EntityExpr deleteCondition = new EntityExpr(MESSAGE_TIME, EntityOperator.LESS_THAN, (Object)new Timestamp(before.getTime()));
        return this.ofBizDelegator.removeByCondition(ENTITY, (EntityCondition)deleteCondition);
    }
}

