/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.cache.ehcache;

import com.atlassian.jira.cluster.cache.ehcache.AbstractJiraCacheReplicator;
import com.atlassian.jira.cluster.cache.ehcache.ClassLoaderSwitchingRunnable;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.RemoteCacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingParallelCacheReplicator
extends AbstractJiraCacheReplicator {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingParallelCacheReplicator.class);
    private final ExecutorService executorService;
    private static final Executor ALWAYS_RUN_STRATEGY = Runnable::run;
    private static final ThreadLocal<Executor> cacheReplicationStrategy = ThreadLocal.withInitial(() -> ALWAYS_RUN_STRATEGY);

    BlockingParallelCacheReplicator(boolean replicatePuts, boolean replicatePutsViaCopy, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals, ExecutorService executorService, Supplier<ReplicationPauserManager> replicationPauserManager) {
        super(replicatePuts, replicatePutsViaCopy, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals, replicationPauserManager);
        this.executorService = executorService;
    }

    @Override
    protected void replicatePutNotification(Ehcache cache, Element element) throws RemoteCacheException {
        this.forEachCachePeer(cache, PeerOperation.create(peer -> peer.put(element), "put", element.getObjectKey()));
    }

    @Override
    protected void replicateRemovalNotification(Ehcache cache, Serializable key) throws RemoteCacheException {
        this.forEachCachePeer(cache, PeerOperation.create(peer -> peer.remove(key), "remove", key));
    }

    @Override
    protected void replicateRemoveAllNotification(Ehcache cache) {
        this.forEachCachePeer(cache, PeerOperation.create(CachePeer::removeAll, "removeAll", null));
    }

    void onReplicationError(Ehcache cache, CachePeer peer, PeerOperation peerOperation, Throwable t) {
        LOG.error("Exception on replication of {}. {}. Cache: {} Peer: {}", new Object[]{peerOperation.operationName, t.getMessage(), cache.getName(), this.getPeerName(peer), t});
    }

    void onReplicationStart(Ehcache cache, PeerOperation peerOperation) {
        String logMessage = "Start replicating cache: {}, operation: {}, key: {}, stacktrace: {}";
        if (LOG.isTraceEnabled()) {
            LOG.trace("Start replicating cache: {}, operation: {}, key: {}, stacktrace: {}", new Object[]{cache.getName(), peerOperation.operationName, peerOperation.operationKeyAsString(), Throwables.getStackTraceAsString((Throwable)new Throwable())});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Start replicating cache: {}, operation: {}, key: {}, stacktrace: {}", new Object[]{cache.getName(), peerOperation.operationName, peerOperation.operationKeyAsString(), "<only-in-trace>"});
        } else {
            LOG.info("Start replicating cache: {}, operation: {}, key: {}, stacktrace: {}", new Object[]{cache.getName(), peerOperation.operationName, "<only-in-debug>", "<only-in-trace>"});
        }
    }

    void onReplicationEnd(Ehcache cache, PeerOperation peerOperation, int numberOfPeers, int numberOfSuccess, Duration duration) {
        String logMessage = "Done replicating cache: {}, operation: {}, key: {}, numberOfPeers: {}, numberOfSuccess: {}, timeMillis: {}, stacktrace: {}";
        if (LOG.isTraceEnabled()) {
            LOG.trace("Done replicating cache: {}, operation: {}, key: {}, numberOfPeers: {}, numberOfSuccess: {}, timeMillis: {}, stacktrace: {}", new Object[]{cache.getName(), peerOperation.operationName, peerOperation.operationKeyAsString(), numberOfPeers, numberOfSuccess, duration.toMillis(), Throwables.getStackTraceAsString((Throwable)new Throwable())});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Done replicating cache: {}, operation: {}, key: {}, numberOfPeers: {}, numberOfSuccess: {}, timeMillis: {}, stacktrace: {}", new Object[]{cache.getName(), peerOperation.operationName, peerOperation.operationKeyAsString(), numberOfPeers, numberOfSuccess, duration.toMillis(), "<only-in-trace>"});
        } else {
            LOG.info("Done replicating cache: {}, operation: {}, key: {}, numberOfPeers: {}, numberOfSuccess: {}, timeMillis: {}, stacktrace: {}", new Object[]{cache.getName(), peerOperation.operationName, "<only-in-debug>", numberOfPeers, numberOfSuccess, duration.toMillis(), "<only-in-trace>"});
        }
    }

    private String getPeerName(CachePeer peer) {
        try {
            return peer.getName();
        }
        catch (RemoteException e) {
            return "undefined";
        }
    }

    private void forEachCachePeer(Ehcache cache, PeerOperation peerOperation) {
        cacheReplicationStrategy.get().execute(() -> {
            this.onReplicationStart(cache, peerOperation);
            Stopwatch stopwatch = Stopwatch.createStarted();
            AtomicInteger numberOfSuccess = new AtomicInteger();
            List cachePeers = Collections.emptyList();
            try {
                cachePeers = cache.getCacheManager().getCacheManagerPeerProvider("RMI").listRemoteCachePeers(cache);
                CompletableFuture.allOf((CompletableFuture[])cachePeers.stream().map(peer -> CompletableFuture.runAsync(new ClassLoaderSwitchingRunnable(() -> {
                    try {
                        peerOperation.operation.accept((CachePeer)peer);
                        numberOfSuccess.incrementAndGet();
                    }
                    catch (Throwable e) {
                        this.onReplicationError(cache, (CachePeer)peer, peerOperation, e);
                    }
                }), this.executorService)).toArray(CompletableFuture[]::new)).join();
            }
            finally {
                this.onReplicationEnd(cache, peerOperation, cachePeers.size(), numberOfSuccess.get(), Duration.ofNanos(stopwatch.stop().elapsed(TimeUnit.NANOSECONDS)));
            }
        });
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new BlockingParallelCacheReplicator(this.replicatePuts, this.replicatePutsViaCopy, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals, this.executorService, this.replicationPauserManager);
    }

    public static <T> T runDeferred(Supplier<T> supplier) {
        DeferredReplicationStrategy deferredReplicationStrategy = new DeferredReplicationStrategy();
        cacheReplicationStrategy.set(deferredReplicationStrategy);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            cacheReplicationStrategy.remove();
            deferredReplicationStrategy.run();
        }
    }

    static class PeerOperation {
        final Operation operation;
        final String operationName;
        final Object operationKey;

        private PeerOperation(Operation operation, String operationName, @Nullable Object operationKey) {
            this.operation = (Operation)Preconditions.checkNotNull((Object)operation);
            this.operationName = (String)Preconditions.checkNotNull((Object)operationName);
            this.operationKey = operationKey;
        }

        String operationKeyAsString() {
            return String.valueOf(this.operationKey);
        }

        static PeerOperation create(Operation operation, String operationName, Object operationKey) {
            return new PeerOperation(operation, operationName, operationKey);
        }

        @FunctionalInterface
        static interface Operation {
            public void accept(CachePeer var1) throws RemoteException;
        }
    }

    public static class DeferredReplicationStrategy
    implements Executor {
        private Runnable replicationRunnable;

        public void run() {
            if (this.replicationRunnable != null) {
                this.replicationRunnable.run();
            }
        }

        @Override
        public void execute(Runnable command) {
            this.replicationRunnable = command;
        }
    }
}

