/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.disasterrecovery;

import com.atlassian.jira.cluster.disasterrecovery.ReplicatorTask;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.util.log.RateLimitingLogger;
import io.atlassian.fugue.Option;
import java.io.File;

class DeleteTask
extends ReplicatorTask {
    private static final RateLimitingLogger log = new RateLimitingLogger(DeleteTask.class);

    DeleteTask(File file, JiraHome jiraHome, SecondaryJiraHome secondaryJiraHome) {
        super(file, jiraHome, secondaryJiraHome);
    }

    @Override
    public void run() {
        Option<String> relativePath = this.getRelativePathOf(this.jiraHome, this.file);
        if (relativePath.isEmpty()) {
            log.warn(" Attempting to replicate [" + this.file.getAbsolutePath() + "] failed because it is not in JIRA home");
            return;
        }
        String secondaryFilePath = PathUtils.joinPaths((String[])new String[]{this.secondaryJiraHome.getHomePath(), (String)relativePath.get()});
        File fileToDelete = new File(secondaryFilePath);
        if (fileToDelete.exists() && !fileToDelete.delete()) {
            log.warn(" Unable to delete file [" + secondaryFilePath + "]");
        }
    }
}

