/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class LocalQCacheOp
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String cacheName;
    private final Action action;
    @Nullable
    private final Serializable key;
    @Nullable
    private final Serializable value;
    private final long creationTimeInMillis;

    private LocalQCacheOp(String cacheName, Action action, @Nullable Serializable key, @Nullable Serializable value) {
        Preconditions.checkNotNull((Object)cacheName);
        Preconditions.checkNotNull((Object)((Object)action));
        this.cacheName = cacheName;
        this.action = action;
        this.key = key;
        this.value = value;
        this.creationTimeInMillis = System.currentTimeMillis();
    }

    @Nullable
    static LocalQCacheOp put(Ehcache ehcache, Element element) {
        Serializable key;
        Serializable serializable = key = element.isKeySerializable() ? (Serializable)element.getObjectKey() : null;
        if (key == null) {
            return null;
        }
        Serializable value = element.isSerializable() ? (Serializable)element.getObjectValue() : null;
        return new LocalQCacheOp(ehcache.getName(), Action.PUT, key, value);
    }

    @Nullable
    static LocalQCacheOp remove(Ehcache ehcache, Object key) {
        if (key instanceof Serializable) {
            return new LocalQCacheOp(ehcache.getName(), Action.REMOVE, (Serializable)key, null);
        }
        return null;
    }

    @Nullable
    static LocalQCacheOp removeAll(Ehcache ehcache) {
        return new LocalQCacheOp(ehcache.getName(), Action.REMOVE_ALL, null, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LocalQCacheOp{");
        sb.append("cacheName='").append(this.cacheName).append('\'');
        sb.append(", action=").append((Object)this.action);
        sb.append(", key=").append(this.key);
        sb.append(", value=").append(this.value);
        sb.append(", creationTimeInMillis=").append(this.creationTimeInMillis);
        sb.append('}');
        return sb.toString();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Action getAction() {
        return this.action;
    }

    @Nullable
    public Serializable getKey() {
        return this.key;
    }

    @Nullable
    public Serializable getValue() {
        return this.value;
    }

    public long getCreationTimeInMillis() {
        return this.creationTimeInMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalQCacheOp that = (LocalQCacheOp)o;
        return this.creationTimeInMillis == that.creationTimeInMillis && Objects.equals(this.getCacheName(), that.getCacheName()) && Objects.equals((Object)this.getAction(), (Object)that.getAction()) && Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getCacheName(), this.getAction(), this.getKey(), this.getValue(), this.creationTimeInMillis});
    }

    public static enum Action {
        PUT,
        REMOVE,
        REMOVE_ALL;

    }
}

