/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.distribution.localq;

import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.distribution.localq.LocalQCacheOpQueue;
import com.atlassian.jira.cluster.distribution.localq.tape.TapeLocalQCacheOpQueue;
import com.atlassian.jira.config.util.JiraHome;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalQCacheOpQueueFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LocalQCacheOpQueueFactory.class);
    private static String QUEUE_FOLDER_NAME = "localq";
    private final JiraHome jiraHome;

    public LocalQCacheOpQueueFactory(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
    }

    private synchronized File getOrCreateQueueHome() {
        File queueFolder = new File(this.jiraHome.getLocalHome(), QUEUE_FOLDER_NAME);
        if (!queueFolder.exists()) {
            if (queueFolder.mkdir()) {
                LOG.debug("Created folder for storing cache replication queues: {}", (Object)queueFolder.getPath());
            } else {
                LOG.error("Could not create: {} folder in Jira Local Home: {}.", (Object)QUEUE_FOLDER_NAME, (Object)this.jiraHome.getLocalHome().getPath());
            }
        }
        if (!queueFolder.exists()) {
            LOG.error("Directory in Jira Local Home: {} not created. Will try storing cache replication queues in Jira Local Home directly.", (Object)QUEUE_FOLDER_NAME);
            return this.jiraHome.getLocalHome();
        }
        return queueFolder;
    }

    public LocalQCacheOpQueue create(Node node, int nodeQueueNumber) throws IOException {
        File queueHome = this.getOrCreateQueueHome();
        return TapeLocalQCacheOpQueue.create(queueHome, node, nodeQueueNumber);
    }
}

