/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.health;

import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.license.ClusterLicenseCheck;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCenterLicenseFixer {
    private static final Logger log = LoggerFactory.getLogger(DataCenterLicenseFixer.class);
    private final ClusterLicenseCheck clusterLicenseCheck;
    private final JiraLicenseManager licenseManager;
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier serviceDeskLicenseSupplier;

    public DataCenterLicenseFixer(ClusterLicenseCheck clusterLicenseCheck, JiraLicenseManager licenseManager, Jira6xServiceDeskPluginEncodedLicenseSupplier serviceDeskLicenseSupplier) {
        this.clusterLicenseCheck = Objects.requireNonNull(clusterLicenseCheck);
        this.licenseManager = Objects.requireNonNull(licenseManager);
        this.serviceDeskLicenseSupplier = Objects.requireNonNull(serviceDeskLicenseSupplier);
    }

    public void removeNonDataCenterLicenses() {
        List<LicenseDetails> failedLicenses = this.clusterLicenseCheck.evaluate().getFailedLicenses();
        if (failedLicenses.isEmpty()) {
            return;
        }
        try {
            this.licenseManager.removeLicenses(failedLicenses);
            log.info("Removed {} DataCenter-incompatible license(s) from this instance", (Object)failedLicenses.size());
        }
        catch (RuntimeException e) {
            log.error("Problem encountered while trying to remove DataCenter-incompatible licenses. DataCenter may not be able to start up. If this problem persists, you may need to remove licenses directly from the data store.", (Throwable)e);
        }
        if (DataCenterLicenseFixer.containsServiceDeskPluginLicense(failedLicenses)) {
            this.serviceDeskLicenseSupplier.get().forEach(sdLicense -> this.serviceDeskLicenseSupplier.moveToUpgradeStore());
        }
    }

    private static boolean containsServiceDeskPluginLicense(Collection<LicenseDetails> failedLicenses) {
        return failedLicenses.stream().anyMatch(lic -> lic.hasApplication(ApplicationKeys.SERVICE_DESK));
    }
}

