/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.core.util.Clock;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.heartbeat.ClusterNodeHeartBeatDao;
import com.atlassian.jira.cluster.lock.HeartbeatJob;
import com.atlassian.jira.cluster.lock.NodeSharedHomeStatus;
import com.atlassian.jira.cluster.lock.SharedHomeNodeStatusWriter;
import com.atlassian.jira.event.cluster.HeartbeatEvent;

public class ClusterHeartbeatJob
implements HeartbeatJob {
    private final ClusterNodeHeartBeatDao clusterNodeHeartBeatDao;
    private final SharedHomeNodeStatusWriter sharedHomeNodeStatusWriter;
    private final Clock clock;
    private final EventPublisher eventPublisher;

    public ClusterHeartbeatJob(ClusterNodeHeartBeatDao clusterNodeHeartBeatDao, SharedHomeNodeStatusWriter sharedHomeNodeStatusWriter, Clock clock, EventPublisher eventPublisher) {
        this.clusterNodeHeartBeatDao = clusterNodeHeartBeatDao;
        this.sharedHomeNodeStatusWriter = sharedHomeNodeStatusWriter;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void run() {
        this.updateClusterNodeHeartbeat();
        this.updateSharedHomeNodeStatus();
        this.publishEvent();
    }

    private void updateClusterNodeHeartbeat() {
        this.clusterNodeHeartBeatDao.writeHeartBeat(this.getCurrentTime());
    }

    private void updateSharedHomeNodeStatus() {
        this.sharedHomeNodeStatusWriter.writeNodeStatus(new NodeSharedHomeStatus(this.getNodeId(), this.getCurrentTime()));
    }

    private void publishEvent() {
        this.eventPublisher.publish((Object)HeartbeatEvent.INSTANCE);
    }

    private String getNodeId() {
        return this.clusterNodeHeartBeatDao.getNodeId();
    }

    private long getCurrentTime() {
        return this.clock.getCurrentDate().getTime();
    }
}

