/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.zdu;

import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateDao;
import com.atlassian.jira.cluster.zdu.DatabaseUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.model.querydsl.ClusterUpgradeStateDTO;
import java.util.EnumSet;
import java.util.Optional;

public class DefaultDatabaseUpgradeStateManager
implements DatabaseUpgradeStateManager {
    private static final EnumSet<UpgradeState> UPGRADE_ALLOWED_STATES = EnumSet.of(UpgradeState.STABLE, UpgradeState.RUNNING_UPGRADE_TASKS);
    private final FeatureManager featureManager;
    private final ClusterUpgradeStateDao clusterUpgradeStateDao;

    public DefaultDatabaseUpgradeStateManager(FeatureManager featureManager, ClusterUpgradeStateDao clusterUpgradeStateDao) {
        this.featureManager = featureManager;
        this.clusterUpgradeStateDao = clusterUpgradeStateDao;
    }

    @Override
    public UpgradeState getDatabaseUpgradeState() {
        Optional<ClusterUpgradeStateDTO> currentState = this.clusterUpgradeStateDao.getCurrent();
        return currentState.map(ClusterUpgradeStateDTO::getState).map(UpgradeState::valueOf).orElse(UpgradeState.STABLE);
    }

    @Override
    public boolean areDelayedUpgradesHandledByCluster() {
        boolean isClusterUpgradeStateDarkFeatureEnabled = this.featureManager.isEnabled("jira.zdu.cluster-upgrade-state");
        return isClusterUpgradeStateDarkFeatureEnabled && this.getDatabaseUpgradeState() != UpgradeState.STABLE;
    }

    @Override
    public boolean areUpgradesAllowedByCluster() {
        boolean isClusterUpgradeStateDarkFeatureEnabled = this.featureManager.isEnabled("jira.zdu.cluster-upgrade-state");
        return !isClusterUpgradeStateDarkFeatureEnabled || UPGRADE_ALLOWED_STATES.contains(this.getDatabaseUpgradeState());
    }
}

