/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.component;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComponentAccessorWorker
implements ComponentAccessor.Worker {
    private final ComponentManager componentManager;

    @Nonnull
    public static ComponentAccessorWorker getInstance() {
        return new ComponentAccessorWorker(ComponentManager.getInstance());
    }

    private ComponentAccessorWorker(ComponentManager componentManager) {
        this.componentManager = Objects.requireNonNull(componentManager);
    }

    public <T> Optional<T> getComponentSafely(Class<T> componentClass) {
        if (this.componentManager.componentsAvailable()) {
            return Optional.ofNullable(this.getComponent(componentClass));
        }
        return Optional.empty();
    }

    @Nullable
    public <T> T getComponent(Class<T> componentClass) {
        try {
            return this.componentManager.getComponent(componentClass);
        }
        catch (RuntimeException re) {
            throw new IllegalStateException("Unable to resolve component: " + componentClass, re);
        }
    }

    public <T> T getComponentOfType(Class<T> componentClass) {
        try {
            return this.componentManager.getComponentInstanceOfType(componentClass);
        }
        catch (RuntimeException re) {
            throw new IllegalStateException("Unable to resolve component: " + componentClass, re);
        }
    }

    public <T> T getOSGiComponentInstanceOfType(Class<T> componentClass) {
        try {
            return this.componentManager.getOSGiComponentInstanceOfType(componentClass);
        }
        catch (RuntimeException re) {
            throw new IllegalStateException("Unable to resolve component: " + componentClass, re);
        }
    }
}

