/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetSchema;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.w3c.dom.Document;

class MemorySwitchToDatabasePropertySet
implements PropertySet {
    AtomicReference<PropertySet> active;
    private PropertySet memoryPropertySet;
    private Supplier<PropertySet> databasePropertySet;

    public MemorySwitchToDatabasePropertySet(PropertySet memoryPropertySet, final PropertySet databasePropertySet) {
        this(memoryPropertySet, new Supplier<PropertySet>(){

            @Override
            public PropertySet get() {
                return databasePropertySet;
            }
        });
    }

    public MemorySwitchToDatabasePropertySet(PropertySet memoryPropertySet, Supplier<PropertySet> propertySetBRef) {
        this.memoryPropertySet = memoryPropertySet;
        this.databasePropertySet = propertySetBRef;
        this.active = new io.atlassian.util.concurrent.atomic.AtomicReference((Object)memoryPropertySet);
    }

    public void switchToDatabaseMode() {
        this.active.compareAndSet(this.memoryPropertySet, this.databasePropertySet.get());
    }

    public void setSchema(PropertySetSchema schema) throws PropertyException {
        this.active.get().setSchema(schema);
    }

    public PropertySetSchema getSchema() throws PropertyException {
        return this.active.get().getSchema();
    }

    public void setAsActualType(String key, Object value) throws PropertyException {
        this.active.get().setAsActualType(key, value);
    }

    public Object getAsActualType(String key) throws PropertyException {
        return this.active.get().getAsActualType(key);
    }

    public void setBoolean(String key, boolean value) throws PropertyException {
        this.active.get().setBoolean(key, value);
    }

    public boolean getBoolean(String key) throws PropertyException {
        return this.active.get().getBoolean(key);
    }

    public void setData(String key, byte[] value) throws PropertyException {
        this.active.get().setData(key, value);
    }

    public byte[] getData(String key) throws PropertyException {
        return this.active.get().getData(key);
    }

    public void setDate(String key, Date value) throws PropertyException {
        this.active.get().setDate(key, value);
    }

    public Date getDate(String key) throws PropertyException {
        return this.active.get().getDate(key);
    }

    public void setDouble(String key, double value) throws PropertyException {
        this.active.get().setDouble(key, value);
    }

    public double getDouble(String key) throws PropertyException {
        return this.active.get().getDouble(key);
    }

    public void setInt(String key, int value) throws PropertyException {
        this.active.get().setInt(key, value);
    }

    public int getInt(String key) throws PropertyException {
        return this.active.get().getInt(key);
    }

    public Collection getKeys() throws PropertyException {
        return this.active.get().getKeys();
    }

    public Collection getKeys(int type) throws PropertyException {
        return this.active.get().getKeys(type);
    }

    public Collection getKeys(String prefix) throws PropertyException {
        return this.active.get().getKeys(prefix);
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        return this.active.get().getKeys(prefix, type);
    }

    public void setLong(String key, long value) throws PropertyException {
        this.active.get().setLong(key, value);
    }

    public long getLong(String key) throws PropertyException {
        return this.active.get().getLong(key);
    }

    public void setObject(String key, Object value) throws PropertyException {
        this.active.get().setObject(key, value);
    }

    public Object getObject(String key) throws PropertyException {
        return this.active.get().getObject(key);
    }

    public void setProperties(String key, Properties value) throws PropertyException {
        this.active.get().setProperties(key, value);
    }

    public Properties getProperties(String key) throws PropertyException {
        return this.active.get().getProperties(key);
    }

    public boolean isSettable(String property) {
        return this.active.get().isSettable(property);
    }

    public void setString(String key, String value) throws PropertyException {
        this.active.get().setString(key, value);
    }

    public String getString(String key) throws PropertyException {
        return this.active.get().getString(key);
    }

    public void setText(String key, String value) throws PropertyException {
        this.active.get().setText(key, value);
    }

    public String getText(String key) throws PropertyException {
        return this.active.get().getText(key);
    }

    public int getType(String key) throws PropertyException {
        return this.active.get().getType(key);
    }

    public void setXML(String key, Document value) throws PropertyException {
        this.active.get().setXML(key, value);
    }

    public Document getXML(String key) throws PropertyException {
        return this.active.get().getXML(key);
    }

    public boolean exists(String key) throws PropertyException {
        return this.active.get().exists(key);
    }

    public void init(Map config, Map args) {
        this.active.get().init(config, args);
    }

    public void remove(String key) throws PropertyException {
        this.active.get().remove(key);
    }

    public void remove() throws PropertyException {
        this.active.get().remove();
    }

    public boolean supportsType(int type) {
        return this.active.get().supportsType(type);
    }

    public boolean supportsTypes() {
        return this.active.get().supportsTypes();
    }

    PropertySet getMemoryPropertySet() {
        return this.memoryPropertySet;
    }

    PropertySet getDatabasePropertySet() {
        return this.databasePropertySet.get();
    }
}

