/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.exception.DataAccessException;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizDelegatingMembershipDao
implements MembershipDao {
    private static final Logger LOG = LoggerFactory.getLogger(OfBizDelegatingMembershipDao.class);
    private static final Function<UserOrGroupStub, String> GET_NAME = new Function<UserOrGroupStub, String>(){

        public String apply(UserOrGroupStub input) {
            return input.getName();
        }
    };
    private final InternalMembershipDao membershipDao;
    private final OfBizGroupDao groupDao;
    private final ExtendedUserDao userDao;

    public OfBizDelegatingMembershipDao(InternalMembershipDao membershipDao, ExtendedUserDao userDao, GroupDao groupDao) {
        this.membershipDao = membershipDao;
        this.groupDao = (OfBizGroupDao)groupDao;
        this.userDao = userDao;
    }

    public BatchResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws GroupNotFoundException {
        BatchResult allResults = new BatchResult(userNames.size());
        ArrayList<UserOrGroupStub> users = new ArrayList<UserOrGroupStub>(userNames.size());
        for (String userName : userNames) {
            try {
                OfBizUser user = this.userDao.findByNameOrNull(directoryId, userName);
                if (user != null) {
                    users.add(user);
                    continue;
                }
                allResults.addFailure((Object)userName);
                LOG.debug("User '" + userName + "' not found");
            }
            catch (DataAccessException e) {
                LOG.debug("Data error trying to resolve user '" + userName + '\'', (Throwable)e);
            }
        }
        if (!users.isEmpty()) {
            OfBizGroup group = this.groupDao.findOfBizGroup(directoryId, groupName);
            BatchResult<String> delegateResults = this.membershipDao.addAllUsersToGroup(directoryId, users, group);
            allResults.addFailures((Collection)delegateResults.getFailedEntities());
            allResults.addSuccesses((Collection)delegateResults.getSuccessfulEntities());
        }
        return allResults;
    }

    public boolean isUserDirectMember(long directoryId, String userName, String groupName) {
        return this.membershipDao.isUserDirectMember(directoryId, userName, groupName);
    }

    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        return this.membershipDao.isGroupDirectMember(directoryId, childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String user, String group) throws UserNotFoundException, GroupNotFoundException, MembershipAlreadyExistsException {
        OfBizUser idUser = this.userDao.findOfBizUser(directoryId, user);
        OfBizGroup idGroup = this.groupDao.findOfBizGroup(directoryId, group);
        this.membershipDao.addUserToGroup(directoryId, idUser, idGroup);
    }

    public void addGroupToGroup(long directoryId, String child, String parent) throws GroupNotFoundException {
        OfBizGroup idChild = this.groupDao.findOfBizGroup(directoryId, child);
        OfBizGroup idParent = this.groupDao.findOfBizGroup(directoryId, parent);
        this.membershipDao.addGroupToGroup(directoryId, idChild, idParent);
    }

    public void removeUserFromGroup(long directoryId, String user, String group) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException {
        OfBizUser idUser = this.userDao.findOfBizUser(directoryId, user);
        OfBizGroup idGroup = this.groupDao.findOfBizGroup(directoryId, group);
        this.membershipDao.removeUserFromGroup(directoryId, idUser, idGroup);
    }

    public void removeGroupFromGroup(long directoryId, String child, String parent) throws GroupNotFoundException, MembershipNotFoundException {
        OfBizGroup idChild = this.groupDao.findOfBizGroup(directoryId, child);
        OfBizGroup idParent = this.groupDao.findOfBizGroup(directoryId, parent);
        this.membershipDao.removeGroupFromGroup(directoryId, idChild, idParent);
    }

    public <T> List<T> search(long directoryId, MembershipQuery<T> query) {
        return this.result(directoryId, query, this.membershipDao.search(directoryId, query));
    }

    public BoundedCount countDirectMembersOfGroup(long directoryId, String groupName, int potentialMaxCount) {
        return BoundedCount.exactly((long)this.membershipDao.countDirectMembersOfGroup(directoryId, groupName, MembershipType.GROUP_USER));
    }

    private <T> List<T> result(long directoryId, MembershipQuery<T> query, List<String> entityNames) throws IllegalStateException {
        if (query.getReturnType().isAssignableFrom(String.class)) {
            return this.doNameQuery(directoryId, entityNames, query.getEntityToReturn());
        }
        if (query.getReturnType().isAssignableFrom(User.class)) {
            return this.doUserQuery(directoryId, entityNames);
        }
        if (query.getReturnType().isAssignableFrom(Group.class)) {
            return this.doGroupQuery(directoryId, entityNames);
        }
        throw new IllegalArgumentException("Class type '" + query.getReturnType() + "' for return values is not 'String', 'User' or 'Group'");
    }

    private List<OfBizGroup> doGroupQuery(long directoryId, List<String> entityNames) {
        ArrayList<OfBizGroup> groups = new ArrayList<OfBizGroup>(entityNames.size());
        for (String groupName : entityNames) {
            OfBizGroup group = this.groupDao.findByNameOrNull(directoryId, groupName);
            if (group == null) continue;
            groups.add(group);
        }
        return groups;
    }

    private List<OfBizUser> doUserQuery(long directoryId, List<String> entityNames) {
        return this.userDao.findAllByNameOrNull(directoryId, entityNames);
    }

    private List<String> doNameQuery(long directoryId, List<String> entityNames, EntityDescriptor descriptor) {
        if (descriptor.equals((Object)EntityDescriptor.user())) {
            return OfBizDelegatingMembershipDao.getNames(this.doUserQuery(directoryId, entityNames));
        }
        if (descriptor.equals((Object)EntityDescriptor.group())) {
            return OfBizDelegatingMembershipDao.getNames(this.doGroupQuery(directoryId, entityNames));
        }
        return Lists.newArrayList();
    }

    private static List<String> getNames(List<? extends UserOrGroupStub> list) {
        return Lists.newArrayList((Iterable)Iterables.transform(list, GET_NAME));
    }
}

