/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.MembershipKey;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.model.querydsl.QMembership;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.cache.WeakInterner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizInternalMembershipDao
implements InternalMembershipDao {
    private static final ImmutableList<String> FIELD_LIST_LOWERCHILDNAME = ImmutableList.of((Object)"lowerChildName");
    private static final ImmutableList<String> FIELD_LIST_LOWERPARENTNAME = ImmutableList.of((Object)"lowerParentName");
    private static final LinkedHashSet<String> EMPTY = new LinkedHashSet();
    private final OfBizDelegator ofBizDelegator;
    private final QueryDslAccessor queryDslAccessor;
    private final Cache<MembershipKey, LinkedHashSet<String>> parentsCache;
    private final Cache<MembershipKey, LinkedHashSet<String>> childrenCache;
    private WeakInterner<String> myInterner = WeakInterner.newWeakInterner();

    public OfBizInternalMembershipDao(OfBizDelegator ofBizDelegator, QueryDslAccessor queryDslAccessor, CacheManager cacheManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.queryDslAccessor = queryDslAccessor;
        this.parentsCache = cacheManager.getCache(OfBizInternalMembershipDao.class.getName() + ".parentsCache", (CacheLoader)new ParentsLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
        this.childrenCache = cacheManager.getCache(OfBizInternalMembershipDao.class.getName() + ".childrenCache", (CacheLoader)new ChildrenLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
    }

    private static boolean canUseCacheSearch(MembershipQuery<?> query) {
        return query.getStartIndex() == 0 && query.getMaxResults() == -1;
    }

    @Override
    public boolean isUserDirectMember(long directoryId, String userName, String groupName) {
        return this.isDirectMember(directoryId, MembershipType.GROUP_USER, groupName, userName);
    }

    @Override
    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        return this.isDirectMember(directoryId, MembershipType.GROUP_GROUP, parentGroup, childGroup);
    }

    private boolean isDirectMember(long directoryId, MembershipType membershipType, String parentName, String childName) {
        Set parents = (Set)this.parentsCache.get((Object)MembershipKey.getKey(directoryId, childName, membershipType));
        return parents != null && (parents.contains(parentName) || parents.contains(IdentifierUtils.toLowerCase((String)parentName)));
    }

    @Override
    public void addUserToGroup(long directoryId, UserOrGroupStub user, UserOrGroupStub group) throws MembershipAlreadyExistsException {
        if (this.isDirectMember(directoryId, MembershipType.GROUP_USER, group.getName(), user.getName())) {
            throw new MembershipAlreadyExistsException(directoryId, user.getName(), group.getName());
        }
        try {
            this.createMembership(directoryId, MembershipType.GROUP_USER, group, user);
        }
        catch (DataAccessException e) {
            if (this.isDirectMember(directoryId, MembershipType.GROUP_USER, group.getName(), user.getName())) {
                throw new MembershipAlreadyExistsException(directoryId, user.getName(), group.getName());
            }
            throw e;
        }
        this.invalidateChildrenCacheEntry(directoryId, group.getName(), MembershipType.GROUP_USER);
        this.invalidateParentsCacheEntry(directoryId, user.getName(), MembershipType.GROUP_USER);
    }

    @Override
    public BatchResult<String> addAllUsersToGroup(long directoryId, Collection<UserOrGroupStub> users, UserOrGroupStub group) {
        LinkedHashSet<String> currentUsers = this.getChildrenOfGroupFromCache(directoryId, group.getName(), MembershipType.GROUP_USER);
        BatchResult result = new BatchResult(users.size());
        boolean groupIsDirty = false;
        for (UserOrGroupStub user : users) {
            try {
                if (currentUsers.contains(user.getLowerName())) {
                    result.addFailure((Object)user.getName());
                } else {
                    this.createMembership(directoryId, MembershipType.GROUP_USER, group, user);
                    this.invalidateParentsCacheEntry(directoryId, user.getName(), MembershipType.GROUP_USER);
                    groupIsDirty = true;
                }
                result.addSuccess((Object)user.getName());
            }
            catch (DataAccessException e) {
                result.addFailure((Object)user.getName());
            }
        }
        if (groupIsDirty) {
            this.invalidateChildrenCacheEntry(directoryId, group.getName(), MembershipType.GROUP_USER);
        }
        return result;
    }

    private void createMembership(long directoryId, MembershipType membershipType, UserOrGroupStub parent, UserOrGroupStub child) {
        this.ofBizDelegator.createValue("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("childId", child.getId()).put("childName", child.getName()).put("lowerChildName", child.getLowerName()).put("parentId", parent.getId()).put("parentName", parent.getName()).put("lowerParentName", parent.getLowerName()).put("membershipType", membershipType.name()).build());
    }

    @Override
    public void addGroupToGroup(long directoryId, UserOrGroupStub child, UserOrGroupStub parent) {
        if (!this.isDirectMember(directoryId, MembershipType.GROUP_GROUP, parent.getName(), child.getName())) {
            this.createMembership(directoryId, MembershipType.GROUP_GROUP, parent, child);
            this.invalidateChildrenCacheEntry(directoryId, parent.getName(), MembershipType.GROUP_GROUP);
            this.invalidateParentsCacheEntry(directoryId, child.getName(), MembershipType.GROUP_GROUP);
        }
    }

    @Override
    public void removeUserFromGroup(long directoryId, UserOrGroupStub user, UserOrGroupStub group) throws MembershipNotFoundException {
        this.removeMembership(directoryId, MembershipType.GROUP_USER, group, user);
        this.invalidateChildrenCacheEntry(directoryId, group.getName(), MembershipType.GROUP_USER);
        this.invalidateParentsCacheEntry(directoryId, user.getName(), MembershipType.GROUP_USER);
    }

    private void removeMembership(long directoryId, MembershipType membershipType, UserOrGroupStub parent, UserOrGroupStub child) throws MembershipNotFoundException {
        GenericValue membershipGenericValue = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("childId", child.getId()).put("parentId", parent.getId()).put("membershipType", membershipType.name()).build()));
        if (membershipGenericValue == null) {
            throw new MembershipNotFoundException(child.getName(), parent.getName());
        }
        this.ofBizDelegator.removeValue(membershipGenericValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroupFromGroup(long directoryId, UserOrGroupStub childGroup, UserOrGroupStub parentGroup) throws MembershipNotFoundException {
        try {
            this.removeMembership(directoryId, MembershipType.GROUP_GROUP, parentGroup, childGroup);
        }
        finally {
            this.invalidateChildrenCacheEntry(directoryId, parentGroup.getName(), MembershipType.GROUP_GROUP);
            this.invalidateParentsCacheEntry(directoryId, childGroup.getName(), MembershipType.GROUP_GROUP);
        }
    }

    @Override
    public long countDirectMembersOfGroup(long directoryId, String groupName, MembershipType type) {
        return Select.from("Membership").whereEqual("directoryId", directoryId).andEqual("lowerParentName", IdentifierUtils.toLowerCase((String)groupName)).andEqual("membershipType", type.name()).runWith(this.ofBizDelegator).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMembersFromGroup(Group group) {
        Stream users = this.getChildrenOfGroupFromCache(group.getDirectoryId(), group.getName(), MembershipType.GROUP_USER).stream();
        Stream childGroups = this.getChildrenOfGroupFromCache(group.getDirectoryId(), group.getName(), MembershipType.GROUP_GROUP).stream();
        try {
            this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", group.getDirectoryId()).put("parentName", group.getName()).build());
        }
        finally {
            users.forEach(userName -> {
                this.invalidateChildrenCacheEntry(group.getDirectoryId(), group.getName(), MembershipType.GROUP_USER);
                this.invalidateParentsCacheEntry(group.getDirectoryId(), (String)userName, MembershipType.GROUP_USER);
            });
            childGroups.forEach(childName -> {
                this.invalidateChildrenCacheEntry(group.getDirectoryId(), group.getName(), MembershipType.GROUP_GROUP);
                this.invalidateParentsCacheEntry(group.getDirectoryId(), (String)childName, MembershipType.GROUP_GROUP);
            });
        }
    }

    @Override
    public void removeAllGroupMemberships(Group group) {
        Stream parentGroups = this.getParentsForMemberFromCache(group.getDirectoryId(), group.getName(), MembershipType.GROUP_GROUP).stream();
        try {
            this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", group.getDirectoryId()).put("membershipType", MembershipType.GROUP_GROUP.name()).put("childName", group.getName()).build());
        }
        finally {
            parentGroups.forEach(parentName -> {
                this.invalidateChildrenCacheEntry(group.getDirectoryId(), (String)parentName, MembershipType.GROUP_GROUP);
                this.invalidateParentsCacheEntry(group.getDirectoryId(), group.getName(), MembershipType.GROUP_GROUP);
            });
        }
    }

    @Override
    public void removeAllUserMemberships(User user) {
        this.removeAllUserMemberships(user.getDirectoryId(), user.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllUserMemberships(long directoryId, String username) {
        Stream groups = this.getParentsForMemberFromCache(directoryId, username, MembershipType.GROUP_USER).stream();
        try {
            this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("membershipType", MembershipType.GROUP_USER.name()).put("childName", username).build());
        }
        finally {
            groups.forEach(groupName -> {
                this.invalidateChildrenCacheEntry(directoryId, (String)groupName, MembershipType.GROUP_USER);
                this.invalidateParentsCacheEntry(directoryId, username, MembershipType.GROUP_USER);
            });
        }
    }

    public List<String> findGroupChildrenOfGroups(long directoryId, Collection<String> groupNames) {
        return this.findChildrenOfGroupsGeneric(directoryId, groupNames, MembershipType.GROUP_GROUP);
    }

    public List<String> findUserChildrenOfGroups(long directoryId, Collection<String> groupNames) {
        return this.findChildrenOfGroupsGeneric(directoryId, groupNames, MembershipType.GROUP_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findChildrenOfGroupsGeneric(long directoryId, Collection<String> groupNames, MembershipType relationship) {
        if (groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        Set adjustedGroupNames = groupNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toSet());
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        EntityExpr parentCondition = new EntityExpr("lowerParentName", EntityOperator.IN, adjustedGroupNames);
        EntityExpr typeCondition = new EntityExpr("membershipType", EntityOperator.EQUALS, (Object)relationship.name());
        EntityConditionList condition = new EntityConditionList((List)ImmutableList.of((Object)directoryCondition, (Object)parentCondition, (Object)typeCondition), EntityOperator.AND);
        try (OfBizListIterator memberships = this.ofBizDelegator.findListIteratorByCondition("Membership", (EntityCondition)condition, null, FIELD_LIST_LOWERCHILDNAME, FIELD_LIST_LOWERCHILDNAME, EntityFindOptions.findOptions().distinct());){
            ArrayList<String> children = new ArrayList<String>(4096);
            GenericValue membership = memberships.next();
            while (membership != null) {
                String child = membership.getString("lowerChildName");
                children.add(this.myInterner.intern(child));
                membership = memberships.next();
            }
            ArrayList<String> arrayList = children;
            return arrayList;
        }
    }

    @Override
    public <T> List<String> search(long directoryId, MembershipQuery<T> query) {
        StringPath column;
        StringPath constraintName;
        if (OfBizInternalMembershipDao.canUseCacheSearch(query)) {
            return this.searchCache(directoryId, query);
        }
        ImmutableList.Builder andFilter = ImmutableList.builder();
        ImmutableList.Builder orFilter = ImmutableList.builder();
        andFilter.add((Object)QMembership.MEMBERSHIP.directoryId.eq((Object)directoryId));
        if (query.getEntityToReturn().equals((Object)EntityDescriptor.user()) || query.getEntityToMatch().equals((Object)EntityDescriptor.user())) {
            andFilter.add((Object)QMembership.MEMBERSHIP.membershipType.eq((Object)MembershipType.GROUP_USER.name()));
        } else {
            andFilter.add((Object)QMembership.MEMBERSHIP.membershipType.eq((Object)MembershipType.GROUP_GROUP.name()));
        }
        if (query.isFindChildren()) {
            constraintName = QMembership.MEMBERSHIP.lowerParentName;
            column = QMembership.MEMBERSHIP.lowerChildName;
        } else {
            constraintName = QMembership.MEMBERSHIP.lowerChildName;
            column = QMembership.MEMBERSHIP.lowerParentName;
        }
        for (String name : query.getEntityNamesToMatch()) {
            orFilter.add((Object)constraintName.eq((Object)IdentifierUtils.toLowerCase((String)name)));
        }
        return this.findMemberships(column, (List<Predicate>)andFilter.build(), (List<Predicate>)orFilter.build(), query.getStartIndex(), query.getMaxResults());
    }

    private List<String> searchCache(long directoryId, MembershipQuery<?> query) {
        MembershipType type = query.getEntityToReturn().equals((Object)EntityDescriptor.user()) || query.getEntityToMatch().equals((Object)EntityDescriptor.user()) ? MembershipType.GROUP_USER : MembershipType.GROUP_GROUP;
        Function<String, Stream> generator = query.isFindChildren() ? entityName -> this.getChildrenOfGroupFromCache(directoryId, (String)entityName, type).stream() : entityName -> this.getParentsForMemberFromCache(directoryId, (String)entityName, type).stream();
        Set entityNamesToMatch = query.getEntityNamesToMatch();
        if (entityNamesToMatch.size() == 1) {
            return generator.apply((String)Iterables.getOnlyElement((Iterable)entityNamesToMatch)).collect(Collectors.toList());
        }
        return entityNamesToMatch.stream().sorted().distinct().collect(Collectors.toList());
    }

    private LinkedHashSet<String> getParentsForMemberFromCache(long directoryId, String childName, MembershipType type) {
        return this.getFromCache(this.parentsCache, directoryId, childName, type);
    }

    private LinkedHashSet<String> getChildrenOfGroupFromCache(long directoryId, String groupName, MembershipType type) {
        return this.getFromCache(this.childrenCache, directoryId, groupName, type);
    }

    private LinkedHashSet<String> getFromCache(Cache<MembershipKey, LinkedHashSet<String>> cache, long directoryId, String name, MembershipType type) {
        LinkedHashSet values = (LinkedHashSet)cache.get((Object)MembershipKey.getKey(directoryId, name, type));
        if (values == null) {
            return EMPTY;
        }
        return values;
    }

    private List<String> findMemberships(StringPath column, List<Predicate> andFilters, List<Predicate> orFilters, int offset, int maxResults) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)column).from((Expression)QMembership.MEMBERSHIP)).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{ExpressionUtils.allOf((Collection)andFilters), ExpressionUtils.anyOf((Collection)orFilters)}))).orderBy(column.asc())).distinct()).offset((long)offset)).limit((long)maxResults)).fetch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashSet<String> findChildren(long directoryId, MembershipType membershipType, String parent) {
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        EntityExpr parentCondition = new EntityExpr("lowerParentName", EntityOperator.EQUALS, (Object)parent);
        EntityExpr typeCondition = new EntityExpr("membershipType", EntityOperator.EQUALS, (Object)membershipType.name());
        EntityConditionList condition = new EntityConditionList((List)ImmutableList.of((Object)directoryCondition, (Object)parentCondition, (Object)typeCondition), EntityOperator.AND);
        try (OfBizListIterator memberships = this.ofBizDelegator.findListIteratorByCondition("Membership", (EntityCondition)condition, null, FIELD_LIST_LOWERCHILDNAME, FIELD_LIST_LOWERCHILDNAME, EntityFindOptions.findOptions().distinct());){
            ArrayList<String> children = new ArrayList<String>(4096);
            GenericValue membership = memberships.next();
            while (membership != null) {
                String child = membership.getString("lowerChildName");
                children.add(this.myInterner.intern(child));
                membership = memberships.next();
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(children);
            return linkedHashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashSet<String> findParents(long directoryId, MembershipType membershipType, String child) {
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        EntityExpr childCondition = new EntityExpr("lowerChildName", EntityOperator.EQUALS, (Object)child);
        EntityExpr typeCondition = new EntityExpr("membershipType", EntityOperator.EQUALS, (Object)membershipType.name());
        EntityConditionList condition = new EntityConditionList((List)ImmutableList.of((Object)directoryCondition, (Object)childCondition, (Object)typeCondition), EntityOperator.AND);
        try (OfBizListIterator memberships = this.ofBizDelegator.findListIteratorByCondition("Membership", (EntityCondition)condition, null, FIELD_LIST_LOWERPARENTNAME, FIELD_LIST_LOWERPARENTNAME, EntityFindOptions.findOptions().distinct());){
            ArrayList<String> parents = new ArrayList<String>(64);
            GenericValue membership = memberships.next();
            while (membership != null) {
                String parent = membership.getString("lowerParentName");
                parents.add(this.myInterner.intern(parent));
                membership = memberships.next();
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(parents);
            return linkedHashSet;
        }
    }

    @Override
    public void flushCache() {
        this.parentsCache.removeAll();
        this.childrenCache.removeAll();
    }

    private void invalidateChildrenCacheEntry(Long directoryId, String parentName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, parentName, type);
        this.childrenCache.remove((Object)key);
    }

    private void invalidateParentsCacheEntry(Long directoryId, String childName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, childName, type);
        this.parentsCache.remove((Object)key);
    }

    private class ChildrenLoader
    implements CacheLoader<MembershipKey, LinkedHashSet<String>> {
        private ChildrenLoader() {
        }

        @Nonnull
        public LinkedHashSet<String> load(@Nonnull MembershipKey key) {
            return OfBizInternalMembershipDao.this.findChildren(key.getDirectoryId(), key.getType(), key.getName());
        }
    }

    private class ParentsLoader
    implements CacheLoader<MembershipKey, LinkedHashSet<String>> {
        private ParentsLoader() {
        }

        @Nonnull
        public LinkedHashSet<String> load(@Nonnull MembershipKey key) {
            return OfBizInternalMembershipDao.this.findParents(key.getDirectoryId(), key.getType(), key.getName());
        }
    }
}

